% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R
\docType{methods}
\name{qualif}
\alias{qualif}
\alias{qualif<-}
\alias{qualif,gbFeature-method}
\alias{qualif<-,gbFeature-method}
\alias{qualif,gbFeatureTable-method}
\alias{qualif,gbRecord-method}
\title{Get/set qualifiers of GenBank features}
\usage{
qualif(x, which = "", ...)

qualif(x, which, check = TRUE) <- value

\S4method{qualif}{gbFeature}(x, which, fixed = FALSE, use.names = TRUE)

\S4method{qualif}{gbFeature}(x, which, check = TRUE) <- value

\S4method{qualif}{gbFeatureTable}(x, which = "", fixed = FALSE,
  use.names = TRUE)

\S4method{qualif}{gbRecord}(x, which = "", fixed = FALSE,
  use.names = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}}, or
\code{\linkS4class{gbRecord}} object.}

\item{which}{A character vector giving the name(s) of the
qualifiers to retrieve or set.}

\item{...}{Additional arguments passed to methods.}

\item{check}{if \code{FALSE}, don't perform validity checks.}

\item{value}{The qualifier information to set on \code{x}.}

\item{fixed}{If \code{TRUE}, \code{which} is matched against qualifiers as is,
if \code{FALSE} it is treated as a regular expression.}

\item{use.names}{If \code{TRUE}, return a \code{data.frame} using \code{which}
as column names, if \code{FALSE} return, if possible, a character vector or
a list.}
}
\value{
A \code{data.frame}.
}
\description{
Get/set qualifiers of GenBank features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
qualif(x[[1]], 'db_xref')

## use shortcuts to common qualifiers
proteinID(x["CDS"])
locusTag(x["CDS"])
}
