% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_optimize_para.R
\name{optimize_para}
\alias{optimize_para}
\title{Process: Optimizing Parameters}
\usage{
optimize_para(
  data,
  id,
  obj_func,
  n_params,
  n_trials,
  lower,
  upper,
  initial_params = NA,
  initial_size = 50,
  iteration = 10,
  seed = 123,
  algorithm
)
}
\arguments{
\item{data}{[data.frame] 
This data should include the following mandatory columns: 
 \itemize{
   \item "sub"
   \item "time_line" (e.g., "Block", "Trial")
   \item "L_choice"
   \item "R_choice"
   \item "L_reward"
   \item "R_reward"
   \item "sub_choose"
 }}

\item{id}{[character]
Specifies the ID of the subject whose optimal parameters will be fitted.
 This parameter accepts either string or numeric values. The provided
 ID must correspond to an existing subject identifier within the raw
 dataset provided to the function.}

\item{obj_func}{[function]
The objective function that the optimization algorithm package accepts.
 This function must strictly take only one argument, `params` (a vector
 of model parameters). Its output must be a single numeric value
 representing the loss function to be minimized. For more detailed
 requirements and examples, please refer to the relevant documentation 
 (
    \code{\link[binaryRL]{TD}}, 
    \code{\link[binaryRL]{RSTD}}, 
    \code{\link[binaryRL]{Utility}}
 ).}

\item{n_params}{[integer] 
The number of free parameters in your model.}

\item{n_trials}{[integer] 
The total number of trials in your experiment.}

\item{lower}{[vector] 
Lower bounds of free parameters}

\item{upper}{[vector] 
Upper bounds of free parameters}

\item{initial_params}{[vector]
Initial values for the free parameters that the optimization algorithm will
 search from. These are primarily relevant when using algorithms that require
 an explicit starting point, such as \code{L-BFGS-B}. If not specified,
 the function will automatically generate initial values close to zero.
 
 \code{default: initial_params = NA}.}

\item{initial_size}{[integer]
This parameter corresponds to the \strong{population size} in genetic 
 algorithms (\code{GA}). It specifies the number of initial candidate
 solutions that the algorithm starts with for its evolutionary search.
 This parameter is only required for optimization algorithms that operate on
 a population, such as `GA` or `DEoptim`. 
 
 \code{default: initial_size = 50}.}

\item{iteration}{[integer] 
The number of iterations the optimization algorithm will perform
 when searching for the best-fitting parameters during the fitting
 phase. A higher number of iterations may increase the likelihood of 
 finding a global optimum but also increases computation time.}

\item{seed}{[integer] 
Random seed. This ensures that the results are 
 reproducible and remain the same each time the function is run. 
 
 \code{default: seed = 123}}

\item{algorithm}{[character] 
Choose an algorithm package from
 `L-BFGS-B`, `GenSA`, `GA`, `DEoptim`, `PSO`, `Bayesian`, `CMA-ES`.
 
In addition, any algorithm from the `nloptr` package is also
 supported. If your chosen `nloptr` algorithm requires a local search,
 you need to input a character vector. The first element represents
 the algorithm used for global search, and the second element represents
 the algorithm used for local search.}
}
\value{
the result of binaryRL with optimal parameters
}
\description{
This is an internal helper function for `fit_p`. Its primary purpose
 is to provide a unified interface for users to interact with various
 optimization algorithm packages. It adapts the inputs and outputs
 to be compatible with eight distinct algorithms, ensuring a seamless
 experience regardless of the underlying solver used.

 The function provides several optimization algorithms:
  \itemize{
    \item 1. L-BFGS-B (from \code{stats::optim})
    \item 2. Simulated Annealing (\code{GenSA::GenSA})
    \item 3. Genetic Algorithm (\code{GA::ga})
    \item 4. Differential Evolution (\code{DEoptim::DEoptim})
    \item 5. Particle Swarm Optimization (\code{pso::psoptim})
    \item 6. Bayesian Optimization (\code{mlrMBO::mbo})
    \item 7. Covariance Matrix Adapting Evolutionary Strategy (\code{cmaes::cma_es})
    \item 8. Nonlinear Optimization (\code{nloptr::nloptr})
  }
  
 For more information, please refer to the homepage of this package:
 \url{https://yuki-961004.github.io/binaryRL/}
}
\examples{
\dontrun{
binaryRL.res <- binaryRL::optimize_para(
  data = binaryRL::Mason_2024_Exp2,
  id = 1,
  obj_func = binaryRL::RSTD,
  n_params = 3,
  n_trials = 360,
  lower = c(0, 0, 0),
  upper = c(1, 1, 1),
  iteration = 10,
  seed = 123,
  algorithm = "L-BFGS-B"   # Gradient-Based (stats)
  #algorithm = "GenSA"    # Simulated Annealing (GenSA)
  #algorithm = "GA"       # Genetic Algorithm (GA)
  #algorithm = "DEoptim"  # Differential Evolution (DEoptim)
  #algorithm = "PSO"      # Particle Swarm Optimization (pso)
  #algorithm = "Bayesian" # Bayesian Optimization (mlrMBO)
  #algorithm = "CMA-ES"   # Covariance Matrix Adapting (cmaes)
  #algorithm = c("NLOPT_GN_MLSL", "NLOPT_LN_BOBYQA")
)
summary(binaryRL.res)
}

}
