% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univLinReg.R
\name{big_univLinReg}
\alias{big_univLinReg}
\title{Column-wise linear regression}
\usage{
big_univLinReg(
  X,
  y.train,
  ind.train = rows_along(X),
  ind.col = cols_along(X),
  covar.train = NULL,
  thr.eigval = 1e-04,
  ncores = 1
)
}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{y.train}{Vector of responses, corresponding to \code{ind.train}.}

\item{ind.train}{An optional vector of the row indices that are used,
for the training part. If not specified, all rows are used.
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{covar.train}{Matrix of covariables to be added in each model to correct
for confounders (e.g. the scores of PCA), corresponding to \code{ind.train}.
Default is \code{NULL} and corresponds to only adding an intercept to each model.
You can use \code{\link[=covar_from_df]{covar_from_df()}} to convert from a data frame.}

\item{thr.eigval}{Threshold to remove "insignificant" singular vectors.
Default is \code{1e-4}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
A data.frame with 3 elements:
\enumerate{
\item the slopes of each regression,
\item the standard errors of each slope,
\item the t-scores associated with each slope.
This is also an object of class \code{mhtest}. See \code{methods(class = "mhtest")}.
}
}
\description{
Slopes of column-wise linear regressions of each column
of a Filebacked Big Matrix, with some other associated statistics.
Covariates can be added to correct for confounders.
}
\examples{
set.seed(1)

X <- big_attachExtdata()
n <- nrow(X)
y <- rnorm(n)
covar <- matrix(rnorm(n * 3), n)

X1 <- X[, 1] # only first column of the Filebacked Big Matrix

# Without covar
test <- big_univLinReg(X, y)
## New class `mhtest`
class(test)
attr(test, "transfo")
attr(test, "predict")
## plot results
plot(test)
plot(test, type = "Volcano")
## To get p-values associated with the test
test$p.value <- predict(test, log10 = FALSE)
str(test)
summary(lm(y ~ X1))$coefficients[2, ]

# With all data
str(big_univLinReg(X, y, covar = covar))
summary(lm(y ~ X1 + covar))$coefficients[2, ]

# With only half of the data
ind.train <- sort(sample(n, n/2))
str(big_univLinReg(X, y[ind.train],
                   covar.train = covar[ind.train, ],
                   ind.train = ind.train))
summary(lm(y ~ X1 + covar, subset = ind.train))$coefficients[2, ]
}
\seealso{
\link[stats:lm]{lm}
}
