% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_correction.r
\name{stability.parameter}
\alias{stability.parameter}
\title{Stability Parameter "zeta"}
\usage{
stability.parameter(
  data,
  Tair = "Tair",
  pressure = "pressure",
  ustar = "ustar",
  H = "H",
  zr,
  d,
  constants = bigleaf.constants()
)
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables}

\item{Tair}{Air temperature (degC)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{ustar}{Friction velocity (m s-1)}

\item{H}{Sensible heat flux (W m-2)}

\item{zr}{Instrument (reference) height (m)}

\item{d}{Zero-plane displacement height (m)}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
k - von Karman constant (-) \cr
g - gravitational acceleration (m s-2)}
}
\value{
\item{\eqn{\zeta} - }{stability parameter (-)}
}
\description{
calculates "zeta", a parameter characterizing stratification in 
             the lower atmosphere.
}
\details{
The stability parameter \eqn{\zeta} is given by:

           \deqn{\zeta = (zr - d) / L}
         
         where L is the Monin-Obukhov length (m), calculated from the function
         \code{\link{Monin.Obukhov.length}}. The displacement height d can 
         be estimated from the function \code{\link{roughness.parameters}}.
}
\examples{
df <- data.frame(Tair=25,pressure=100,ustar=seq(0.2,1,0.1),H=seq(40,200,20))
stability.parameter(df,zr=40,d=15)

}
