% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_plot.R
\name{bdm.wtt.plot}
\alias{bdm.wtt.plot}
\title{Plot WTT (clustering)}
\usage{
bdm.wtt.plot(bdm, pakde.pltt = NULL, pakde.lvls = 16, wtt.lwd = 1,
  plot.peaks = T, labels.cex = 1, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()} or a list of them to make a comparative plot.}

\item{pakde.pltt}{A colour palette to show levels in the paKDE plot. By default (\code{pakde.pltt = NULL}) the default palette is used.}

\item{pakde.lvls}{The number of levels of the density heat-map (16 by default).}

\item{wtt.lwd}{The width of the watertrack lines (as set in \code{par()}).}

\item{plot.peaks}{Logical value (TRUE by default). If set to TRUE and the up-stream step \code{bdm$wtt()} is computed marks the peak of each cluster.}

\item{labels.cex}{If \var{plot.peaks} is TRUE, the size of the labels of the clusters (as set in \code{par()}). By default \code{labels.cex = 0.0} and the labels of the clusters are not depicted.}

\item{layer}{The \var{bdm$ptsne} layer to be used (default value is \code{layer = 1}).}
}
\value{
None.
}
\description{
Plot WTT (clustering)
}
\examples{

bdm.example()
exMap <- bdm.wtt.plot(exMap)
}
