% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_beta_parms.R
\name{find_beta_parms}
\alias{find_beta_parms}
\title{Find parameters for Beta prior based on prior mean and one quantile}
\usage{
find_beta_parms(
  mean,
  quantile,
  left_tail_prob,
  plot_results = TRUE,
  search_bounds = c(0.001, 100)
)
}
\arguments{
\item{mean}{numeric between 0 and 1 giving the prior mean}

\item{quantile}{numeric between 0 and 1 giving the quantile lying at left_tail_prob}

\item{left_tail_prob}{numeric between 0 and 1 giving the prior probability of theta
being less than or equal to quantile}

\item{plot_results}{logical. Should the resulting inverse gamma distribution be plotted?}

\item{search_bounds}{bounds with which to search.  Sometimes you need to adjust this to get a good solution.}
}
\value{
Vector of beta shape parameters
}
\description{
Find parameters for Beta prior based on prior mean and one quantile
}
\examples{
find_beta_parms(2/5,0.68,0.9)
2/ (2 + 3)
qbeta(0.9,2,3)


}
