% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metropolis_Hastings_Algorithms.R
\name{RWMH}
\alias{RWMH}
\title{Random Walk Metropolis-Hastings Algorithm}
\usage{
RWMH(data, propob = NULL, posterior = NULL, iter = 1500,
  burn = 500, vscale = 1.5, start = NULL, prior = "Normal",
  mu = 0, sig = 10)
}
\arguments{
\item{data}{data required for the posterior distribution. First column is the outcome}

\item{propob}{a list of mean and variance-covariance of the normal proposal distribution
(default: NULL i.e. internally generated)}

\item{posterior}{the posterior distribution. It is set to null in order to use the logit posterior.
The user can specify log posterior as a function of parameters and data (pars,data)}

\item{iter}{number of random draws desired}

\item{burn}{burn-in period for the Random Walk MH algorithm}

\item{vscale}{a positive value to scale up or down the variance-covariance matrix in
the proposal distribution}

\item{start}{starting values of parameters for the MH algorithm.
It is automatically generated from the proposal distribution but the user can also specify.}

\item{prior}{the prior distribution (default: "Normal", alternative: "Uniform")}

\item{mu}{the mean of the normal prior distribution (default:0)}

\item{sig}{the variance of the normal prior distribution (default:10)}
}
\value{
val a list of matrix of draws Matpram and the acceptance rate
}
\description{
\code{RWMH} computes random draws of parameters using a specified proposal distribution.
The default is the normal distribution
}
\examples{
y = indicat(faithful$waiting,70)
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
data = data.frame(y,x); propob<- lapl_aprx(y,x)
RWMHob_n<- RWMH(data=data,propob,iter = 102, burn = 2) # prior="Normal"
RWMHob_u<- RWMH(data=data,propob,prior="Uniform",iter = 102, burn = 2)
par(mfrow=c(3,1));invisible(apply(RWMHob_n$Matpram,2,function(x)plot(density(x))))
invisible(apply(RWMHob_u$Matpram,2,function(x)plot(density(x))));par(mfrow=c(1,1))

}
