% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootHillModel.R
\name{calcHillBootstrap}
\alias{calcHillBootstrap}
\title{Estimate Bootstrapped Confidence Intervals on Hill Model Parameters}
\usage{
calcHillBootstrap(hfit, ciLevs = c(0.025, 0.975), numBoot = NULL)
}
\arguments{
\item{hfit}{An object of class \code{hillrm}}

\item{ciLevs}{The lower and upper p-values for the estimated confidence
interval.  The default values, 0.025 and 0.975, produce a 95\% confidence
interval.}

\item{numBoot}{The number of bootstrapped coefficients to be sampled.  If
\code{NULL} (the default) will be selected to have at least 10 samples lie
the selected interval, with a minimum of 100 and a maximum of 1000.}
}
\value{
An object of class \code{hillrm}, containing all the values found in any
\code{hillrm} object (see \code{\link[=fitHillModel]{fitHillModel()}}) as well as the following three
values:
\itemize{
\item \code{ciLevs}: the values used to set the bounds of the confidence intervals
\item \code{ciCoefs}: a width-4 array of all bootstrapped Hill model coefficents
sampled by the function
\item \code{ciMat}: a 2-by-4 array of values representing the estimated confidence
intervals on the four Hill model parameters
}
}
\description{
By bootsttrapping a large number of vectors, this function estimates
confidence intervals on the paramters of the given Hill model.  If the model
already has confidence intervals estimated, they will be replaced with a
warning
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,75)
response <- evalHillModel(conc, hpar) + rnorm(length(conc),sd=7.5)

hfit <- fitHillModel(conc,response,c(1,2,3,4),start=c(0.5,1,0,100))
cihfit <- calcHillBootstrap(hfit)
}
