% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-lange.R
\encoding{UTF-8}
\name{model.lange.customize}
\alias{model.lange.customize}
\title{Customize the Lange model}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_base}{Base temperature to calculate degree days to trigger the onset.}

\item{dd_onset_threshold}{Degree days that are required to trigger the onset of
infestation. Additionally, the maximum temperature must exceed \code{tfly}.}

\item{tfly}{Minimum temperature that beetles need to fly.}

\item{dd_base_stages}{Base temperatures to calculate degree days for the
different stages in the following order: egg, larva, pupa, juvenile adult.}

\item{dd_threshold_stages}{Thermal thresholds for the different stages in the
following order: egg, larva, pupa, juvenile adult.}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{first_lethal_date}{Date before which no mortality will be modeled.}

\item{tlethal}{Temperature threshold below which white stages (egg, larva, pupa) will die.}
}
\description{
This page describes the parameters
that can be used to customize Lange. The model was developed by
\insertCite{Lange2008;textual}{barrks}. Look \link[=model.lange.apply]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for the Lange model and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model("lange",

      # ==== onset ==== #

      dd_onset_start_date = '01-01',
      dd_onset_base = 5,
      dd_onset_threshold = 110,

      # ==== onset + development ====

      tfly = 19.5,

      # ==== development ==== #

      dd_base_stages = c(10.6, 8.2, 9.9, 3.2),
      dd_threshold_stages = c(51.8, 204.4, 57.7, 238.5),

      model_end_date = '12-31',

      # ==== mortality ==== #

      first_lethal_date = '09-01',
      tlethal = 0
)
}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.lange.apply}}

Other model customizations: 
\code{\link{model.bso.customize}},
\code{\link{model.chapy.customize}},
\code{\link{model.joensson.customize}},
\code{\link{model.phenips.customize}},
\code{\link{model.phenips_clim.customize}},
\code{\link{model.rity.customize}}
}
\concept{model customizations}
