% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_banff_launcher.R
\name{banff_launcher}
\alias{banff_launcher}
\title{Launch the program}
\usage{
banff_launcher(
  input_file,
  output_folder,
  language = "label:en",
  option_filter,
  detail = FALSE
)
}
\arguments{
\item{input_file}{A character string identifying the path of the input file
(must be a CSV or a one sheet Excel file)
to be processed.}

\item{output_folder}{A character string identifying the folder path where
the output files will be saved.}

\item{language}{Optional argument allowing the user to get the diagnoses in a
specific language. Options are "label:en" (default), "label:fr", "label:de",
"label:sp", "label:nl", "label:jp", "label:in".}

\item{option_filter}{Optional argument allowing the user to filter the
dataset using \code{\link[dplyr:filter]{dplyr::filter()}} syntax. The variable used to filter must
exist.}

\item{detail}{Optional argument indicating whether the output should
include temporary variables generated in the process or not. FALSE by default.}
}
\value{
Nothing to be returned. The function generates a folder (if not already
existing) where Excel files are stored.
}
\description{
This function takes a path string identifying the input file path. The
function internally runs a series of tests that assess the input dataset. If
any of these tests fails, the user gets information allowing them to correct
the input dataset and rerun the process. Once all tests pass, the dataset
is given as an output with a diagnosis for each observation (using the
function \code{\link[=add_diagnoses]{add_diagnoses()}} internally). The output dataset, along with its
associated labels (\code{label:en} by default) are provided to the user in an Excel
format file accessible in the output_folder specified. The output dataset
comes with a report that summarizes information about variable distributions
and descriptive statistics.
}
\examples{
{

input_file <- system.file("extdata", "banff_template.xlsx", package = "banffIT")
banff_launcher(input_file, output_folder = tempdir())

}

}
