% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_var_time}
\alias{set_var_time}
\title{Specify Time Variable}
\usage{
set_var_time(mod, name)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{name}{The name of the time variable.}
}
\value{
A \code{bage_mod} object
}
\description{
Specify which variable (if any) represents time.
Functions \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}},
and \code{\link[=mod_norm]{mod_norm()}} try to infer the time variable
from variable names, but do not always get it right.
}
\details{
In an R \code{\link{formula}}, a 'variable' is different
from a 'term'. For instance,

\code{~ time + region + time:region}

contains variables \code{time} and \code{region},
and terms \code{time}, \code{region}, and \code{time:region}.

By default, \strong{bage} gives a term involving time a
(\code{\link[=RW]{RW()}}) prior. Changing the time variable
via \code{set_var_time()} can change priors:
see below for an example.

If \code{set_var_time()} is applied to
a fitted model, it 'unfits'
the model, deleting existing estimates.
}
\examples{
## rename time variable to something unusual
injuries2 <- nzl_injuries
injuries2$calendar_year <- injuries2$year

## mod_pois does not recognize time variable
mod <- mod_pois(injuries ~ age * ethnicity + calendar_year,
                data = injuries2,
                exposure = popn)
mod

## so we set the time variable explicitly
## (which, as a side effect, changes the prior on
## the time main effect)
mod |>
  set_var_time(name = "calendar_year")
}
\seealso{
\itemize{
\item \code{\link[=set_var_age]{set_var_age()}} Set age variable
\item \code{\link[=set_var_sexgender]{set_var_sexgender()}} Sex sex or gender variable
\item \code{\link[=is_fitted]{is_fitted()}} Test if model has been fitted
\item internally, \strong{bage} uses \code{\link[poputils:find_var_time]{poputils::find_var_time()}}
to locate time variables
}
}
