% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{forecast.bage_mod}
\alias{forecast.bage_mod}
\title{Use a Model to Make a Forecast}
\usage{
\method{forecast}{bage_mod}(
  object,
  newdata = NULL,
  output = c("augment", "components"),
  include_estimates = FALSE,
  labels = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{bage_mod} object,
typically created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{newdata}{Data frame with data for
future periods.}

\item{output}{Type of output returned}

\item{include_estimates}{Whether to
include historical estimates along
with the forecasts. Default is \code{FALSE}.}

\item{labels}{Labels for future values.}

\item{...}{Not currently used.}
}
\value{
A \link[tibble:tibble-package]{tibble}.
}
\description{
Forecast rates, probabilities, means, and
other model parameters.
}
\section{How the forecasts are constructed}{


Internally, the steps involved in a forecast are:
\enumerate{
\item Forecast time-varying main effects and interactions,
e.g. a time main effect, or an age-time interaction.
\item Combine forecasts for the time-varying main effects and
interactions with non-time-varying parameters, e.g.
age effects or dispersion.
\item Use the combined parameters to generate values for
rates, probabilities or means.
\item If a \code{newdata} argument has been provided,
and \code{output} is \code{"augment"},
draw values for outcome.
}

\code{vignette("vig2_math")} has the technical details.
}

\section{Output}{


When \code{output} is \code{"augment"} (the default),
the return value from \code{forecast()}
looks like output from function \code{\link[=augment]{augment()}}. When \code{output} is
\code{"components"}, the return value looks like output
from \code{\link[=components]{components()}}.

When \code{include_estimates} is \code{FALSE} (the default),
the output of \code{forecast()} excludes values for
time-varying parameters for the period covered by the data.
When \code{include_estimates} is \code{TRUE}, the output
includes these values.
Setting \code{include_estimates} to \code{TRUE} can be helpful
when creating graphs that combine estimates and forecasts.
}

\section{Fitted and unfitted models}{


\code{forecast()} is typically used with a
\link[=fit]{fitted} model, i.e. a model in which parameter
values have been estimated from the data.
The resulting forecasts reflect data and priors.

\code{forecast()} can, however, be used with an
unfitted model. In this case, the forecasts
are based entirely on the priors. See below for
an example. Experimenting with forecasts
based entirely on the priors can be helpful for
choosing an appropriate model.
}

\section{Warning}{


The interface for \code{forecast()} has not been finalised.
}

\examples{
## specify and fit model
mod <- mod_pois(injuries ~ age * sex + ethnicity + year,
                data = nzl_injuries,
                exposure = popn) |>
  fit()
mod

## forecasts
mod |>
  forecast(labels = 2019:2024)

## combined estimates and forecasts
mod |>
  forecast(labels = 2019:2024,
           include_estimates = TRUE)

## hyper-parameters
mod |>
  forecast(labels = 2019:2024,
           output = "components")

## hold back some data and forecast
library(dplyr, warn.conflicts = FALSE)
data_historical <- nzl_injuries |>
  filter(year <= 2015)
data_forecast <- nzl_injuries |>
  filter(year > 2015) |>
  mutate(injuries = NA)
mod_pois(injuries ~ age * sex + ethnicity + year,
         data = data_historical,
         exposure = popn) |>
  fit() |>
  forecast(newdata = data_forecast)

## forecast based on priors only
mod_unfitted <- mod_pois(injuries ~ age * sex + ethnicity + year,
                         data = nzl_injuries,
                         exposure = popn)
mod_unfitted |>
  forecast(labels = 2019:2024)
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} to specify a model
\item \code{\link[=fit]{fit()}} to fit a model
}
}
