test_that("Un_tilde returns valid upper confidence limits", {
  epsilon <- 0.05

  # Typical cases
  expect_true(Un_tilde(0, 10, epsilon) >= 0)
  expect_true(Un_tilde(5, 10, epsilon) >= 0.5)
  expect_true(Un_tilde(9, 10, epsilon) <= 1)

  # S = n returns 1
  expect_equal(Un_tilde(10, 10, epsilon), 1)

  # Values always between 0 and 1
  for (S in 0:10) {
    val <- Un_tilde(S, 10, epsilon)
    expect_gte(val, 0)
    expect_lte(val, 1)
  }
})

test_that("Ln_tilde returns valid lower confidence limits", {
  epsilon <- 0.05

  # Typical cases
  expect_true(Ln_tilde(0, 10, epsilon) >= 0)
  expect_true(Ln_tilde(5, 10, epsilon) <= 0.5)
  expect_true(Ln_tilde(9, 10, epsilon) >= 0)

  # S = 0 returns 0
  expect_equal(Ln_tilde(0, 10, epsilon), 0)

  # Values always between 0 and 1
  for (S in 0:10) {
    val <- Ln_tilde(S, 10, epsilon)
    expect_gte(val, 0)
    expect_lte(val, 1)
  }
})

test_that("invert_Un_tilde approximately inverts Un_tilde", {
  epsilon <- 0.05
  n <- 20

  # Test S from 0 to n
  for (S in 0:n) {
    upper <- Un_tilde(S, n, epsilon)
    S_inv <- invert_Un_tilde(upper, n, epsilon)

    # invert_Un_tilde may be approximate, but S_inv should be close to S
    expect_true(abs(S_inv - S) <= 1)
  }
})

test_that("invert_Un_tilde handles edge cases", {
  epsilon <- 0.05
  n <- 10

  # When Un_tilde = 0, should return ~0 successes
  expect_true(invert_Un_tilde(0, n, epsilon) >= 0)

  # When Un_tilde = 1, should return close to n successes
  expect_true(abs(invert_Un_tilde(1, n, epsilon) - n) <= 1)
})
