% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$auxiliary}
\alias{AUTO_VI$auxiliary}
\title{Compute auxiliary variables for the keras model}
\arguments{
\item{data}{Data frame. A data frame containing variables \code{.resid} and
\code{.fitted}. See also \code{\link[=AUTO_VI$get_fitted_and_resid]{AUTO_VI$get_fitted_and_resid()}}.}
}
\value{
A tibble.
}
\description{
This function computes auxiliary variables
including monotonic measure (\code{measure_monotonic}),
sparse measure (\code{measure_sparse}), splines measure (\code{measure_splines}),
striped measure (\code{measure_striped}), and the number of observation (\code{n}).
Scagnostics are computed using
\code{\link[cassowaryr:sc_monotonic]{cassowaryr::sc_monotonic()}}, \code{\link[cassowaryr:sc_sparse2]{cassowaryr::sc_sparse2()}}, \code{\link[cassowaryr:sc_splines]{cassowaryr::sc_splines()}},
and \code{\link[cassowaryr:sc_striped]{cassowaryr::sc_striped()}}.

If you wish to calculate additional auxiliary variables for your keras
model, please override this method. Ensure that it accepts a data frame
with columns named \code{.fitted} and \code{.resid} as input and returns
a single row tibble.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$auxiliary(data = seflf$get_fitted_and_resid())
}\if{html}{\out{</div>}}
}
}
\examples{

my_vi <- auto_vi(fitted_model = lm(speed ~ dist, data = cars))
my_vi$auxiliary()
}
