% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_pending_ops}
\alias{am_pending_ops}
\title{Get the number of pending operations}
\usage{
am_pending_ops(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
An integer indicating the number of pending operations. Returns 0
if there are no uncommitted changes.
}
\description{
Returns the number of operations that have been applied to the document
but not yet committed. This is useful for determining whether a commit
is needed.
}
\examples{
doc <- am_create()
am_pending_ops(doc)  # 0

doc$key <- "value"
am_pending_ops(doc)  # > 0

am_commit(doc)
am_pending_ops(doc)  # 0

am_close(doc)

}
