% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_get_last_local_change}
\alias{am_get_last_local_change}
\title{Get the last change made by the local actor}
\usage{
am_get_last_local_change(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A raw vector containing the serialized change, or \code{NULL} if no
local changes have been made.
}
\description{
Returns the most recent change created by this document's actor.
Useful for tracking local changes or implementing undo/redo functionality.
}
\examples{
doc <- am_create()

# Initially, no local changes
am_get_last_local_change(doc)  # NULL

# Make a change
doc$key <- "value"
am_commit(doc, "Add key")

# Now we have a local change
change <- am_get_last_local_change(doc)
str(change)  # Raw vector

am_close(doc)

}
