% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor_position}
\alias{am_cursor_position}
\title{Get the current position of a cursor}
\usage{
am_cursor_position(cursor)
}
\arguments{
\item{cursor}{An \code{am_cursor} object created by \code{\link[=am_cursor]{am_cursor()}}}
}
\value{
Integer position (0-based inter-character position) where the cursor
currently points. See \code{\link[=am_cursor]{am_cursor()}} for indexing details.
}
\description{
Retrieves the current position of a cursor within a text object. The
position automatically adjusts as text is inserted or deleted before
the cursor's original position. The cursor remembers which text object
it was created for, so you only need to pass the cursor itself.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

# Create cursor
cursor <- am_cursor(text_obj, 5)

# Get position
pos <- am_cursor_position(cursor)
pos  # 5
}
