% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsSummary.R
\name{modelsSummaryTable}
\alias{modelsSummaryTable}
\title{Makes flextable summarizing list of models}
\usage{
modelsSummaryTable(fitlist, labels = NULL, show.lik = FALSE)
}
\arguments{
\item{fitlist}{A list of objects of class "coxph"}

\item{labels}{character labels of models}

\item{show.lik}{logical Whether or not show likelihood test results}
}
\value{
A flextable
}
\description{
Makes flextable summarizing list of models
}
\examples{
library(survival)
fit1=coxph(Surv(time,status) ~rx,data=anderson)
fit2=coxph(Surv(time,status) ~rx+logWBC,data=anderson)
fit3=coxph(Surv(time,status) ~rx*logWBC,data=anderson)
fitlist=list(fit1,fit2,fit3)
modelsSummaryTable(fitlist)
}
