% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze.R
\name{gaze}
\alias{gaze}
\alias{gaze.formula}
\alias{gaze.data.frame}
\title{Produce table for descriptive statistics}
\usage{
gaze(x, ...)

\method{gaze}{formula}(x, ...)

\method{gaze}{data.frame}(x, ...)
}
\arguments{
\item{x}{An R object, formula or data.frame}

\item{...}{arguments to be passed to gaze.data.frame or gaze.formula}
}
\value{
An object of class "gaze" which inherits from the class "data.frame"
with at least the following attributes:
\describe{
\item{attr(*,"yvars)}{character. name of dependent variable}
}
}
\description{
Produce table for descriptive statistics by groups for several variables easily.
Depending on  the nature of these variables, different descriptive statistical
methods were used(t-test, ANOVA, Kruskal-Wallis, chi-squared, Fisher's,...)
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: S3 method for formula

\item \code{data.frame}: default S3 method
}}

\examples{
library(moonBook)
library(dplyr)
gaze(acs)
gaze(~age+sex,data=acs)
gaze(sex~.,data=acs,digits=1,method=1,show.p=TRUE) \%>\% myft()
\donttest{
gaze(sex~age+Dx,data=acs)
gaze(EF~.,data=acs) \%>\% myft()
gaze(sex+Dx~.,data=acs,show.p=TRUE) \%>\% myft()
gaze(sex+Dx~.,data=acs)
gaze(Dx+sex~cardiogenicShock,data=acs,show.p=TRUE) \%>\% myft()
gaze(Dx+sex+HBP~cardiogenicShock,data=acs,show.p=TRUE)
gaze(~mpg+cyl,data=mtcars)
gaze(~.,data=mtcars)
gaze(cyl~.,data=mtcars,show.p=TRUE)
gaze(hp~.,data=mtcars)
gaze(cyl+am~.,data=mtcars)
}
}
