% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\docType{class}
\name{DictionaryType}
\alias{DictionaryType}
\title{DictionaryType class}
\description{
\code{DictionaryType} is a \link{FixedWidthType} that represents dictionary-encoded data.
Dictionary encoding stores unique values in a dictionary and uses integer-type
indices to reference them, which can be more memory-efficient for data with many
repeated values.
}
\section{R6 Methods}{

\itemize{
\item \verb{$ToString()}: Return a string representation of the dictionary type
\item \verb{$code(namespace = FALSE)}: Return R code to create this dictionary type
}
}

\section{Active bindings}{

\itemize{
\item \verb{$index_type}: The \link{DataType} for the dictionary indices (must be an integer type,
signed or unsigned)
\item \verb{$value_type}: The \link{DataType} for the dictionary values
\item \verb{$name}: The name of the type.
\item \verb{$ordered}: Whether the dictionary is ordered.
}
}

\section{Factory}{


\code{DictionaryType$create()} takes the following arguments:
\itemize{
\item \code{index_type}: A \link{DataType} for the indices (default \code{\link[=int32]{int32()}})
\item \code{value_type}: A \link{DataType} for the values (default \code{\link[=utf8]{utf8()}})
\item \code{ordered}: Is this an ordered dictionary (default \code{FALSE})?
}
}

