% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R, R/list.R, R/struct.R
\name{data-type}
\alias{data-type}
\alias{int8}
\alias{int16}
\alias{int32}
\alias{int64}
\alias{uint8}
\alias{uint16}
\alias{uint32}
\alias{uint64}
\alias{float16}
\alias{halffloat}
\alias{float32}
\alias{float}
\alias{float64}
\alias{boolean}
\alias{bool}
\alias{utf8}
\alias{string}
\alias{date32}
\alias{date64}
\alias{time32}
\alias{time64}
\alias{null}
\alias{timestamp}
\alias{decimal}
\alias{list_of}
\alias{struct}
\title{Apache Arrow data types}
\usage{
int8()

int16()

int32()

int64()

uint8()

uint16()

uint32()

uint64()

float16()

halffloat()

float32()

float()

float64()

boolean()

bool()

utf8()

string()

date32()

date64()

time32(unit = c("ms", "s"))

time64(unit = c("ns", "us"))

null()

timestamp(unit = c("s", "ms", "us", "ns"), timezone)

decimal(precision, scale)

list_of(type)

struct(...)
}
\arguments{
\item{unit}{For time/timestamp types, the time unit. \code{time32()} can take
either "s" or "ms", while \code{time64()} can be "us" or "ns". \code{timestamp()} can
take any of those four values.}

\item{timezone}{For \code{timestamp()}, an optional time zone string.}

\item{precision}{For \code{decimal()}, precision}

\item{scale}{For \code{decimal()}, scale}

\item{type}{For \code{list_of()}, a data type to make a list-of-type}

\item{...}{For \code{struct()}, a named list of types to define the struct columns}
}
\value{
An Arrow type object inheriting from DataType.
}
\description{
These functions create type objects corresponding to Arrow types. Use them
when defining a \code{\link[=schema]{schema()}} or as inputs to other types, like \code{struct}. Most
of these functions don't take arguments, but a few do.
}
\details{
A few functions have aliases:
\itemize{
\item \code{utf8()} and \code{string()}
\item \code{float16()} and \code{halffloat()}
\item \code{float32()} and \code{float()}
\item \code{bool()} and \code{boolean()}
\item Called from \code{schema()} or \code{struct()}, \code{double()} also is supported as a
way of creating a \code{float64()}
}

\code{date32()} creates a datetime type with a "day" unit, like the R \code{Date}
class. \code{date64()} has a "ms" unit.
}
\examples{
\donttest{
bool()
struct(a = int32(), b = double())
timestamp("ms", timezone = "CEST")
time64("ns")
}
}
\seealso{
\code{\link[=dictionary]{dictionary()}} for creating a dictionary (factor-like) type.
}
