% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{getConfVectorForROC}
\alias{getConfVectorForROC}
\title{Returns vector with confidences for the positive class (useful for ROC or AUC computation)}
\usage{
getConfVectorForROC(confidences, predictedClass, positiveClass)
}
\arguments{
\item{confidences}{Vector of confidences}

\item{predictedClass}{Vector with predicted classes}

\item{positiveClass}{Positive class (String)}
}
\value{
Vector of confidence values
}
\description{
Methods for computing ROC curves require a vector of confidences
of the positive class, while in qCBA, the confidence returned by predict.qCBARuleModel with
outputProbabilies = TRUE returns confidence for the predicted class.
This method converts the values to confidences for the positive class
}
\examples{
predictedClass = c("setosa","virginica")
confidences = c(0.9,0.6)
baseClass="setosa"
getConfVectorForROC(confidences,predictedClass,baseClass)
}
