% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunique.R
\name{lunique}
\alias{lunique}
\title{Eliminate duplicate instances of profile IDs in a list of SoilProfileCollections}
\usage{
lunique(l)
}
\arguments{
\item{l}{A list of SoilProfileCollections.}
}
\value{
A list of SoilProfileCollections, with duplicate profile IDs removed.
}
\description{
@description Experimental function to "clean" list input where duplicates exist (that would otherwise prevent \code{pbindlist}). Useful for queries that may have overlapping instances of the same data, for instance a list of SoilProfileCollections where each list element contains profiles gathered from a set of (potentially overlapping) extents.
}
\examples{

data(sp5)

# EXAMPLE #1 -- resolving overlap

# 6 profiles in four sets, and 5,6,7 are missing
input <- lapply(list(c(1,3,4), c(2,2,3), NA, c(8,9,1)), function(idx) {
      if(!all(is.na(idx)))
       sp5[idx,]
})

output <- lunique(input)

# 6 profiles are in final SPC; 5,6,7 are missing
match(profile_id(pbindlist(output)), profile_id(sp5))

# EXAMPLE #2 -- exact duplicates

# deliberately duplicate an SPC
sp5_2 <- sp5
res <- lunique(list(sp5, sp5_2))

# the number of profiles in first element is equal to number in sp5
length(res[[1]]) == length(sp5)

# second list element contains NA b/c all uniques are in #1
res[[2]]

}
\author{
Andrew G. Brown
}
