% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOverlap-fixOverlap.R
\name{findOverlap}
\alias{findOverlap}
\alias{fixOverlap}
\title{Establish which elements within a vector of horizontal positions overlap beyond a given threshold}
\usage{
findOverlap(x, thresh)

fixOverlap(
  x,
  thresh = 0.6,
  adj = 0.2,
  min.x = 0.8,
  max.x = length(x) + 0.2,
  maxIter = 1000,
  trace = FALSE
)
}
\arguments{
\item{x}{vector of horizontal positions}

\item{thresh}{horizontal threshold defining "overlap", must be < 1, ideal
values likely in [0.3, 0.8]}

\item{adj}{adjustments are tested within \code{runif(min=adj * -1, max=adj)}}

\item{min.x}{left-side boundary condition}

\item{max.x}{right-side boundary condition}

\item{maxIter}{maximum number of iterations to attempt before giving up and
returning integer sequence}

\item{trace}{print diagnostics'}
}
\value{
\itemize{
\item \code{findOverlap} a vector of the same length as \code{x}, preserving rank-ordering and boundary conditions.
}

\itemize{
\item \code{findOverlap} a vector of the same length as \code{x}, preserving rank-ordering and boundary conditions.
}
}
\description{
This function is actually quite stupid as it can converge on bogus results
scaled adjustments based on deviation from threshold distances would be better
}
\note{
This is a very naive function and may fail to converge on a reasonable
solution. SANN would be a much more robust framework.
}
\author{
D.E. Beaudette
}
