% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aphylo_from_data_frame.R
\name{aphylo_from_data_frame}
\alias{aphylo_from_data_frame}
\title{Create an \code{aphylo} object with partial annotations}
\usage{
aphylo_from_data_frame(tree, annotations, types = NULL)
}
\arguments{
\item{tree}{An object of class \code{phylo}.}

\item{annotations}{A \link{data.frame} with annotations. The first column should
be the gene id (see details).}

\item{types}{A \link{data.frame} with types. Just like the annotations, the first
column should be the gene id.}
}
\value{
An object of class \link{aphylo}.
}
\description{
Create an \code{aphylo} object with partial annotations
}
\details{
Each row in the the \code{annotations} data frame passed to this function
must have a unique row per gene, and one column per function (GO term). The id
of each gene must match the labels in the \code{tree} object. Missing genes are
annotated with \code{NA} (9).

In the case of \code{types}, while tips can also be annotated with a type, which
should be either 0, duplication, or 1, speciation, only internal nodes
are required. Tip types are ignored.
}
\examples{
# Generating a test dataset
set.seed(1371)
x <- raphylo(20)

# Extracting the tree and annotations
tree <- x$tree

anno <- with(x, rbind(tip.annotation, node.annotation))
anno <- data.frame(id = with(tree, c(tip.label, node.label)), anno)

types <- data.frame(id = tree$node.label, x$node.type)

# Creating a aphylo tree without node types
aphylo_from_data_frame(tree, anno)

# Now including types
aphylo_from_data_frame(tree, anno, types)

# Dropping some data
aphylo_from_data_frame(tree, anno[sample.int(nrow(anno), 10),])

}
\seealso{
Other Data management functions: 
\code{\link{aphylo-class}}
}
\concept{Data management functions}
