/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPEnvironment;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;

public class JRIEngine
extends REngine {
    static final int NILSXP = 0;
    static final int SYMSXP = 1;
    static final int LISTSXP = 2;
    static final int CLOSXP = 3;
    static final int ENVSXP = 4;
    static final int PROMSXP = 5;
    static final int LANGSXP = 6;
    static final int SPECIALSXP = 7;
    static final int BUILTINSXP = 8;
    static final int CHARSXP = 9;
    static final int LGLSXP = 10;
    static final int INTSXP = 13;
    static final int REALSXP = 14;
    static final int CPLXSXP = 15;
    static final int STRSXP = 16;
    static final int DOTSXP = 17;
    static final int ANYSXP = 18;
    static final int VECSXP = 19;
    static final int EXPRSXP = 20;
    static final int BCODESXP = 21;
    static final int EXTPTRSXP = 22;
    static final int WEAKREFSXP = 23;
    static final int RAWSXP = 24;
    static final int S4SXP = 25;
    static JRIEngine jriEngine = null;
    Rengine rni = null;
    RMainLoopCallbacks callbackObject = null;
    Mutex rniMutex = new Mutex();
    long R_UnboundValue;
    long R_NilValue;
    public REXPReference globalEnv;
    public REXPReference emptyEnv;
    public REXPReference baseEnv;
    public REXPReference nullValueRef;
    public REXPNull nullValue;

    public static REngine createEngine() throws REngineException {
        if (jriEngine == null) {
            jriEngine = new JRIEngine();
        }
        return jriEngine;
    }

    public Rengine getRni() {
        return this.rni;
    }

    public JRIEngine() throws REngineException {
        this(new String[]{"--no-save"}, null);
    }

    public JRIEngine(String[] stringArray) throws REngineException {
        this(stringArray, null);
    }

    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks) throws REngineException {
        this.rni = new Rengine(stringArray, rMainLoopCallbacks != null, rMainLoopCallbacks);
        if (!this.rni.waitForR()) {
            throw new REngineException((REngine)this, "Unable to initialize R");
        }
        JRIEngine jRIEngine = this;
        if (jRIEngine.rni.rniGetVersion() < 265L) {
            throw new REngineException((REngine)this, "R JRI engine is too old - RNI API 1.9 (JRI 0.5) or newer is required");
        }
        this.globalEnv = new REXPReference((REngine)this, (Object)new Long(this.rni.rniSpecialObject(1)));
        this.R_NilValue = this.rni.rniSpecialObject(0);
        this.nullValueRef = new REXPReference((REngine)this, (Object)new Long(this.R_NilValue));
        this.emptyEnv = new REXPReference((REngine)this, (Object)new Long(this.rni.rniSpecialObject(2)));
        this.baseEnv = new REXPReference((REngine)this, (Object)new Long(this.rni.rniSpecialObject(3)));
        this.nullValue = new REXPNull();
        this.R_UnboundValue = this.rni.rniSpecialObject(4);
    }

    public JRIEngine(Rengine rengine) throws REngineException {
        this.rni = rengine;
        JRIEngine jRIEngine = this;
        if (jRIEngine.rni.rniGetVersion() < 265L) {
            throw new REngineException((REngine)this, "R JRI engine is too old - RNI API 1.9 (JRI 0.5) or newer is required");
        }
        this.globalEnv = new REXPReference((REngine)this, (Object)new Long(this.rni.rniSpecialObject(1)));
        this.R_NilValue = this.rni.rniSpecialObject(0);
        this.nullValueRef = new REXPReference((REngine)this, (Object)new Long(this.R_NilValue));
        this.emptyEnv = new REXPReference((REngine)this, (Object)new Long(this.rni.rniSpecialObject(2)));
        this.baseEnv = new REXPReference((REngine)this, (Object)new Long(this.rni.rniSpecialObject(3)));
        this.nullValue = new REXPNull();
        this.R_UnboundValue = this.rni.rniSpecialObject(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP parse(String string, boolean bl) throws REngineException {
        REXPReference rEXPReference = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l = this.rni.rniParse(string, -1);
            if (l == 0L || l == this.R_NilValue) {
                throw new REngineException((REngine)this, "Parse Error");
            }
            this.rni.rniPreserve(l);
            rEXPReference = new REXPReference((REngine)this, (Object)new Long(l));
            if (bl) {
                try {
                    rEXPReference = this.resolveReference((REXP)rEXPReference);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXPReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP eval(REXP rEXP, REXP rEXP2, boolean bl) throws REngineException, REXPMismatchException {
        REXPReference rEXPReference = null;
        long l = 0L;
        if (rEXP2 != null && !rEXP2.isReference()) {
            if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                throw new REXPMismatchException(rEXP2, "environment");
            }
            l = (Long)((REXPEnvironment)rEXP2).getHandle();
        } else if (rEXP2 != null) {
            l = (Long)((REXPReference)rEXP2).getHandle();
        }
        if (rEXP == null) {
            throw new REngineException((REngine)this, "null object to evaluate");
        }
        if (!rEXP.isReference()) {
            if (rEXP.isExpression() || rEXP.isLanguage()) {
                rEXP = this.createReference(rEXP);
            } else {
                throw new REXPMismatchException(rEXP2, "reference, expression or language");
            }
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniEval((Long)((REXPReference)rEXP).getHandle(), l);
            if (l2 == -1L) {
                throw new REngineException((REngine)this, "Eval error (invalid input)");
            }
            this.rni.rniPreserve(l2);
            rEXPReference = new REXPReference((REngine)this, (Object)new Long(l2));
            if (bl) {
                rEXPReference = this.resolveReference((REXP)rEXPReference);
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXPReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(String string, REXP rEXP, REXP rEXP2) throws REngineException, REXPMismatchException {
        long l = 0L;
        if (rEXP2 != null && !rEXP2.isReference()) {
            if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                throw new REXPMismatchException(rEXP2, "environment");
            }
            l = (Long)((REXPEnvironment)rEXP2).getHandle();
        } else if (rEXP2 != null) {
            l = (Long)((REXPReference)rEXP2).getHandle();
        }
        if (rEXP == null) {
            rEXP = this.nullValueRef;
        }
        if (!rEXP.isReference()) {
            rEXP = this.createReference(rEXP);
        }
        boolean bl = this.rniMutex.safeLock();
        try {
            this.rni.rniAssign(string, (Long)((REXPReference)rEXP).getHandle(), l);
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP get(String string, REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        REXPReference rEXPReference = null;
        long l = 0L;
        if (rEXP != null && !rEXP.isReference()) {
            if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                throw new REXPMismatchException(rEXP, "environment");
            }
            l = (Long)((REXPEnvironment)rEXP).getHandle();
        } else if (rEXP != null) {
            l = (Long)((REXPReference)rEXP).getHandle();
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniFindVar(string, l);
            if (l2 == this.R_UnboundValue || l2 == 0L) {
                REXP rEXP2 = null;
                return rEXP2;
            }
            this.rni.rniPreserve(l2);
            rEXPReference = new REXPReference((REngine)this, (Object)new Long(l2));
            if (bl) {
                try {
                    rEXPReference = this.resolveReference((REXP)rEXPReference);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXPReference;
    }

    public REXP resolveReference(REXP rEXP) throws REngineException, REXPMismatchException {
        Object var2_2 = null;
        if (rEXP == null) {
            throw new REngineException((REngine)this, "resolveReference called on NULL input");
        }
        if (!rEXP.isReference()) {
            throw new REXPMismatchException(rEXP, "reference");
        }
        long l = (Long)((REXPReference)rEXP).getHandle();
        if (l == 0L) {
            return this.nullValue;
        }
        return this.resolvePointer(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    REXP resolvePointer(long l) throws REngineException, REXPMismatchException {
        if (l == 0L) {
            return this.nullValue;
        }
        REXPS4 rEXPS4 = null;
        boolean bl = this.rniMutex.safeLock();
        try {
            long l2;
            String[] stringArray;
            int n = this.rni.rniExpType(l);
            String[] stringArray2 = this.rni.rniGetAttrNames(l);
            REXPList rEXPList = null;
            if (stringArray2 != null && stringArray2.length > 0) {
                stringArray = new RList();
                for (int i = 0; i < stringArray2.length; ++i) {
                    REXP rEXP;
                    l2 = this.rni.rniGetAttr(l, stringArray2[i]);
                    if (l2 == 0L || l2 == this.R_NilValue || (rEXP = this.resolvePointer(l2)) == null || rEXP == this.nullValue) continue;
                    stringArray.put((Object)stringArray2[i], (Object)rEXP);
                }
                if (stringArray.size() > 0) {
                    rEXPList = new REXPList((RList)stringArray);
                }
            }
            switch (n) {
                case 0: {
                    stringArray = this.nullValue;
                    return stringArray;
                }
                case 16: {
                    stringArray = this.rni.rniGetStringArray(l);
                    rEXPS4 = new REXPString(stringArray, rEXPList);
                    return rEXPS4;
                }
                case 13: {
                    long l3;
                    if (this.rni.rniInherits(l, "factor") && (l3 = this.rni.rniGetAttr(l, "levels")) != 0L) {
                        String[] stringArray3 = null;
                        int n2 = this.rni.rniExpType(l3);
                        if (n2 == 16) {
                            stringArray3 = this.rni.rniGetStringArray(l3);
                            int[] nArray = this.rni.rniGetIntArray(l);
                            rEXPS4 = new REXPFactor(nArray, stringArray3, rEXPList);
                        }
                    }
                    if (rEXPS4 != null) return rEXPS4;
                    rEXPS4 = new REXPInteger(this.rni.rniGetIntArray(l), rEXPList);
                    return rEXPS4;
                }
                case 14: {
                    rEXPS4 = new REXPDouble(this.rni.rniGetDoubleArray(l), rEXPList);
                    return rEXPS4;
                }
                case 10: {
                    int[] nArray = this.rni.rniGetBoolArrayI(l);
                    byte[] byArray = new byte[nArray.length];
                    int n3 = 0;
                    while (true) {
                        if (n3 >= nArray.length) {
                            rEXPS4 = new REXPLogical(byArray, rEXPList);
                            return rEXPS4;
                        }
                        byArray[n3] = nArray[n3] == 0 || nArray[n3] == 1 ? (byte)nArray[n3] : (byte)-128;
                        ++n3;
                    }
                }
                case 19: {
                    long[] lArray = this.rni.rniGetVector(l);
                    REXP[] rEXPArray = new REXP[lArray.length];
                    long l4 = this.rni.rniGetAttr(l, "names");
                    String[] stringArray4 = null;
                    if (l4 != 0L && this.rni.rniExpType(l4) == 16) {
                        stringArray4 = this.rni.rniGetStringArray(l4);
                    }
                    for (int i = 0; i < lArray.length; ++i) {
                        rEXPArray[i] = this.resolvePointer(lArray[i]);
                    }
                    RList rList = stringArray4 == null ? new RList(rEXPArray) : new RList(rEXPArray, stringArray4);
                    rEXPS4 = new REXPGenericVector(rList, rEXPList);
                    return rEXPS4;
                }
                case 24: {
                    rEXPS4 = new REXPRaw(this.rni.rniGetRawArray(l), rEXPList);
                    return rEXPS4;
                }
                case 2: 
                case 6: {
                    RList rList = new RList();
                    l2 = l;
                    while (l2 != 0L && l2 != this.R_NilValue) {
                        long l5 = this.rni.rniCAR(l2);
                        long l6 = this.rni.rniTAG(l2);
                        String string = null;
                        if (this.rni.rniExpType(l6) == 1) {
                            string = this.rni.rniGetSymbolName(l6);
                        }
                        REXP rEXP = this.resolvePointer(l5);
                        if (string == null) {
                            rList.add((Object)rEXP);
                        } else {
                            rList.put((Object)string, (Object)rEXP);
                        }
                        l2 = this.rni.rniCDR(l2);
                    }
                    rEXPS4 = n == 6 ? new REXPLanguage(rList, rEXPList) : new REXPList(rList, rEXPList);
                    return rEXPS4;
                }
                case 1: {
                    rEXPS4 = new REXPSymbol(this.rni.rniGetSymbolName(l));
                    return rEXPS4;
                }
                case 4: {
                    rEXPS4 = new REXPEnvironment((REngine)this, (Object)new Long(l));
                    return rEXPS4;
                }
                case 25: {
                    rEXPS4 = new REXPS4(rEXPList);
                    return rEXPS4;
                }
            }
            return rEXPS4;
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
    }

    public REXP createReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP == null) {
            throw new REngineException((REngine)this, "createReference from a NULL value");
        }
        if (rEXP.isReference()) {
            return rEXP;
        }
        long l = this.createReferencePointer(rEXP);
        if (l == 0L) {
            return null;
        }
        return new REXPReference((REngine)this, (Object)new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createReferencePointer(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP.isReference()) {
            REXPReference rEXPReference = (REXPReference)rEXP;
            if (rEXPReference.getEngine() != this) {
                throw new REXPMismatchException(rEXP, "reference (cross-engine reference is invalid)");
            }
            return (Long)rEXPReference.getHandle();
        }
        boolean bl = this.rniMutex.safeLock();
        int n = 0;
        try {
            Object object;
            int n2;
            int n3;
            long l = 0L;
            if (rEXP.isNull()) {
                long l2 = this.R_NilValue;
                return l2;
            }
            if (rEXP.isLogical()) {
                int[] nArray = rEXP.asIntegers();
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = nArray[i] < 0 ? 2 : (nArray[i] == 0 ? 0 : 1);
                }
                l = this.rni.rniPutBoolArrayI(nArray);
            } else if (rEXP.isInteger()) {
                l = this.rni.rniPutIntArray(rEXP.asIntegers());
            } else if (rEXP.isRaw()) {
                l = this.rni.rniPutRawArray(rEXP.asBytes());
            } else if (rEXP.isNumeric()) {
                l = this.rni.rniPutDoubleArray(rEXP.asDoubles());
            } else if (rEXP.isString()) {
                l = this.rni.rniPutStringArray(rEXP.asStrings());
            } else if (rEXP.isEnvironment()) {
                Long l3 = (Long)((REXPEnvironment)rEXP).getHandle();
                if (l3 == null) {
                    long l4 = this.rni.rniParse("new.env(parent=baseenv())", 1);
                    l = this.rni.rniEval(l4, 0L);
                } else {
                    l = l3;
                }
            } else if (rEXP.isPairList()) {
                boolean bl2 = rEXP.isLanguage();
                RList rList = rEXP.asList();
                l = this.R_NilValue;
                n3 = rList.size();
                if (n3 == 0) {
                    l = this.rni.rniCons(this.R_NilValue, 0L, 0L, bl2);
                } else {
                    for (n2 = n3 - 1; n2 >= 0; --n2) {
                        long l5;
                        object = rList.at(n2);
                        String string = rList.keyAt(n2);
                        long l6 = 0L;
                        if (string != null) {
                            l6 = this.rni.rniInstallSymbol(string);
                        }
                        if ((l5 = this.createReferencePointer((REXP)object)) == 0L) {
                            l5 = this.R_NilValue;
                        }
                        long l7 = this.rni.rniCons(l5, l, l6, n2 == 0 && bl2);
                        this.rni.rniPreserve(l7);
                        this.rni.rniRelease(l);
                        l = l7;
                    }
                }
            } else if (rEXP.isList()) {
                int n4 = n;
                RList rList = rEXP.asList();
                long[] lArray = new long[rList.size()];
                for (n2 = 0; n2 < lArray.length; ++n2) {
                    object = rList.at(n2);
                    if (object == null || object.isNull()) {
                        lArray[n2] = this.R_NilValue;
                        continue;
                    }
                    long l8 = this.createReferencePointer((REXP)object);
                    if (l8 != 0L && l8 != this.R_NilValue) {
                        this.rni.rniProtect(l8);
                        ++n;
                    } else {
                        l8 = this.R_NilValue;
                    }
                    lArray[n2] = l8;
                }
                l = this.rni.rniPutVector(lArray);
                if (n4 > n) {
                    this.rni.rniUnprotect(n - n4);
                    n = n4;
                }
            } else if (rEXP.isSymbol()) {
                long l9 = this.rni.rniInstallSymbol(rEXP.asString());
                return l9;
            }
            if (l == this.R_NilValue) {
                long l10 = l;
                return l10;
            }
            if (l != 0L) {
                REXPList rEXPList = rEXP._attr();
                if (rEXPList == null || !rEXPList.isPairList()) {
                    long l11 = l;
                    return l11;
                }
                RList rList = rEXPList.asList();
                if (rList == null || rList.size() < 1 || !rList.isNamed()) {
                    long l12 = l;
                    return l12;
                }
                this.rni.rniProtect(l);
                ++n;
                for (n3 = 0; n3 < rList.size(); ++n3) {
                    long l13;
                    REXP rEXP2 = rList.at(n3);
                    object = rList.keyAt(n3);
                    if (object == null || (l13 = this.createReferencePointer(rEXP2)) == 0L || l13 == this.R_NilValue) continue;
                    this.rni.rniSetAttr(l, (String)object, l13);
                }
                long l14 = l;
                return l14;
            }
        }
        finally {
            if (n > 0) {
                this.rni.rniUnprotect(n);
            }
            if (bl) {
                this.rniMutex.unlock();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP != null && rEXP.isReference()) {
            long l = (Long)((REXPReference)rEXP).getHandle();
            boolean bl = this.rniMutex.safeLock();
            try {
                this.rni.rniRelease(l);
            }
            finally {
                if (bl) {
                    this.rniMutex.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP getParentEnvironment(REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        REXPReference rEXPReference = null;
        long l = 0L;
        if (rEXP != null && !rEXP.isReference()) {
            if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                throw new REXPMismatchException(rEXP, "environment");
            }
            l = (Long)((REXPEnvironment)rEXP).getHandle();
        } else if (rEXP != null) {
            l = (Long)((REXPReference)rEXP).getHandle();
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniParentEnv(l);
            if (l2 == 0L || l2 == this.R_NilValue) {
                REXP rEXP2 = null;
                return rEXP2;
            }
            rEXPReference = new REXPReference((REngine)this, (Object)new Long(l2));
            if (bl) {
                rEXPReference = this.resolveReference((REXP)rEXPReference);
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXPReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP newEnvironment(REXP rEXP, boolean bl) throws REXPMismatchException, REngineException {
        REXPReference rEXPReference = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l = (Long)((REXPEnvironment)rEXP).getHandle();
            } else if (rEXP != null) {
                l = (Long)((REXPReference)rEXP).getHandle();
            }
            if (l == 0L) {
                l = (Long)this.globalEnv.getHandle();
            }
            long l2 = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new.env"), this.rni.rniCons(l, this.R_NilValue, this.rni.rniInstallSymbol("parent"), false)), 0L);
            rEXPReference = new REXPReference((REngine)this, (Object)new Long(l2));
            if (bl) {
                rEXPReference = this.resolveReference((REXP)rEXPReference);
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXPReference;
    }

    public boolean close() {
        if (this.rni == null) {
            return false;
        }
        this.rni.end();
        return true;
    }

    public synchronized int tryLock() {
        int n = this.rniMutex.tryLock();
        return n == 1 ? 0 : (n == -1 ? 2 : 1);
    }

    public synchronized int lock() {
        return this.rniMutex.safeLock() ? 1 : 2;
    }

    public synchronized void unlock(int n) {
        if (n == 1) {
            this.rniMutex.unlock();
        }
    }

    public boolean supportsReferences() {
        return true;
    }

    public boolean supportsEnvironments() {
        return true;
    }

    public boolean supportsLocking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP wrap(Object object) {
        REXP rEXP = super.wrap(object);
        if (rEXP == null) {
            boolean bl = this.rniMutex.safeLock();
            try {
                org.rosuda.JRI.REXP rEXP2 = this.rni.createRJavaRef(object);
                if (rEXP2 != null) {
                    rEXP = new REXPReference((REngine)this, (Object)new Long(rEXP2.xp));
                }
            }
            finally {
                if (bl) {
                    this.rniMutex.unlock();
                }
            }
        }
        return rEXP;
    }
}

