/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.REngineRegistry;
import org.rosuda.REngine.UniqueID;

public class REXPEnvironment
extends REXP {
    transient REngine eng;
    Object handle;

    public REXPEnvironment(REngine rEngine, Object object) {
        this.eng = rEngine;
        this.handle = object;
    }

    public boolean isEnvironment() {
        return true;
    }

    public Object getHandle() {
        return this.handle;
    }

    public REXP get(String string, boolean bl) throws REngineException {
        try {
            return this.eng.get(string, this, bl);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this.eng, "REXPMismatchException:" + rEXPMismatchException + " in get()");
        }
    }

    public REXP get(String string) throws REngineException {
        return this.get(string, true);
    }

    public void assign(String string, REXP rEXP) throws REngineException, REXPMismatchException {
        this.eng.assign(string, rEXP, this);
    }

    public REXP parent(boolean bl) throws REngineException {
        try {
            return this.eng.getParentEnvironment(this, bl);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this.eng, "REXPMismatchException:" + rEXPMismatchException + " in parent()");
        }
    }

    public REXPEnvironment parent() throws REngineException {
        return (REXPEnvironment)this.parent(true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(REngineRegistry.getId(this.eng));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        UniqueID uniqueID = (UniqueID)objectInputStream.readObject();
        this.eng = REngineRegistry.getEngine(uniqueID);
    }
}

