/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.TeeOutputStream;

public class SSHExec
extends SSHBase {
    private static final int BUFFER_SIZE = 8192;
    private static final int RETRY_INTERVAL = 500;
    private String command = null;
    private long maxwait = 0L;
    private Thread thread = null;
    private String outputProperty = null;
    private File outputFile = null;
    private boolean append = false;
    private Resource commandResource = null;
    private static final String TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandResource(String f) {
        this.commandResource = new FileResource(new File(f));
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setOutputproperty(String property) {
        this.outputProperty = property;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.getHost() == null) {
            throw new BuildException("Host is required.");
        }
        if (this.getUserInfo().getName() == null) {
            throw new BuildException("Username is required.");
        }
        if (this.getUserInfo().getKeyfile() == null && this.getUserInfo().getPassword() == null) {
            throw new BuildException("Password or Keyfile is required.");
        }
        if (this.command == null && this.commandResource == null) {
            throw new BuildException("Command or commandResource is required.");
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (this.command != null) {
                    this.log("cmd : " + this.command, 2);
                    ByteArrayOutputStream out = this.executeCommand(session, this.command);
                    if (this.outputProperty != null) {
                        this.getProject().setNewProperty(this.outputProperty, this.command + " : " + out);
                    }
                } else {
                    try {
                        String cmd;
                        BufferedReader br = new BufferedReader(new InputStreamReader(this.commandResource.getInputStream()));
                        String output = "";
                        while ((cmd = br.readLine()) != null) {
                            this.log("cmd : " + cmd, 2);
                            ByteArrayOutputStream out = this.executeCommand(session, cmd);
                            output = output + cmd + " : " + out + "\n";
                        }
                        if (this.outputProperty != null) {
                            this.getProject().setNewProperty(this.outputProperty, output);
                        }
                        FileUtils.close((Reader)br);
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                Object var7_9 = null;
                if (session == null) return;
            }
            catch (JSchException e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (session == null) throw throwable;
            if (!session.isConnected()) throw throwable;
            session.disconnect();
            throw throwable;
        }
        if (!session.isConnected()) return;
        session.disconnect();
    }

    private ByteArrayOutputStream executeCommand(Session session, String cmd) throws BuildException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TeeOutputStream tee = new TeeOutputStream((OutputStream)out, (OutputStream)new KeepAliveOutputStream((OutputStream)System.out));
        try {
            session.setTimeout((int)this.maxwait);
            final ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(cmd);
            channel.setOutputStream((OutputStream)tee);
            channel.setExtOutputStream((OutputStream)tee);
            channel.connect();
            this.thread = new Thread(){

                public void run() {
                    while (!channel.isClosed()) {
                        if (SSHExec.this.thread == null) {
                            return;
                        }
                        try {
                            1.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            this.thread.start();
            this.thread.join(this.maxwait);
            if (this.thread.isAlive()) {
                this.thread = null;
                if (this.getFailonerror()) {
                    throw new BuildException(TIMEOUT_MESSAGE);
                }
                this.log(TIMEOUT_MESSAGE, 0);
            } else {
                int ec;
                if (this.outputFile != null) {
                    this.writeToFile(out.toString(), this.append, this.outputFile);
                }
                if ((ec = channel.getExitStatus()) != 0) {
                    String msg = "Remote command failed with exit status " + ec;
                    if (this.getFailonerror()) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (JSchException e) {
            if (e.getMessage().indexOf("session is down") >= 0) {
                if (this.getFailonerror()) {
                    throw new BuildException(TIMEOUT_MESSAGE, (Throwable)e);
                }
                this.log(TIMEOUT_MESSAGE, 0);
            } else {
                if (this.getFailonerror()) {
                    throw new BuildException((Throwable)e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
        catch (Exception e) {
            if (this.getFailonerror()) {
                throw new BuildException((Throwable)e);
            }
            this.log("Caught exception: " + e.getMessage(), 0);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeToFile(String from, boolean append, File to) throws IOException {
        FileWriter out = null;
        try {
            int bytesRead;
            out = new FileWriter(to.getAbsolutePath(), append);
            StringReader in = new StringReader(from);
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            Object var9_8 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

