% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{sql2sqlite}
\alias{sql2sqlite}
\title{Convert sql file to sqlite database}
\usage{
sql2sqlite(sql.file = "", statements = "", dbname = "", verbose = FALSE,
  ...)
}
\arguments{
\item{sql.file}{SQL file of sqlite database dumped}

\item{statements}{SQL statements split by ';\\n' (small dataset)}

\item{dbname}{Path of output sqlite database}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other parameters be used in dbSendQuery}
}
\description{
Convert sql file to sqlite database
}
\examples{
sql.file <- system.file('extdata', 'demo/hg19_avsnp147.sqlite.sql', package = 'annovarR')
out.sqlite <- tempfile()
sqlite <- Sys.which(c('sqlite3', 'sqlite'))
sqlite <- sqlite[sqlite != ''][1]
sqlite <- unname(sqlite)
if (!is.na(sqlite)) {
  sql2sqlite(sql.file = sql.file, dbname = out.sqlite, 
  verbose = FALSE)
  unlink(out.sqlite)
}
statements <- paste0(readLines(sql.file), collapse = '\\n')
sql2sqlite(statements = statements, dbname = out.sqlite, 
verbose = FALSE)
unlink(out.sqlite)
}
