% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download.database}
\alias{download.database}
\title{Download annovarR databases}
\usage{
download.database(download.name = NULL, database.dir = tempdir(),
  version = c(), buildver = "hg19", download.cfg = system.file("extdata",
  "config/db/db_annovar.toml", package = "BioInstaller"),
  show.all.versions = FALSE, show.all.names = FALSE,
  show.all.buildvers = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{download.name}{Download name, default is NULL and get value from database.cfg 
dependence_db}

\item{database.dir}{Destination directory to store databases}

\item{version}{Version of download database, supported version can be get by 
download.database('db_annovar_avsnp', show.all.versions = TRUE)}

\item{buildver}{Genome version, e.g hg19, hg38, mm10}

\item{download.cfg}{Configuration file for download, most of annovarR database 
resources can be found in system.file('extdata', 
'config/db/db_annovar.toml', package = 'BioInstaller')}

\item{show.all.versions}{Logical indicating wheather show all avaliable versions}

\item{show.all.names}{Logical indicating wheather show all avaliable name}

\item{show.all.buildvers}{Logical indicating wheather show all avaliable buildver}

\item{verbose}{Logical indicating wheather print the extra log infomation}

\item{...}{Other parameters pass to \code{\link[BioInstaller]{install.bioinfo}}}
}
\description{
Download annovarR databases
}
\examples{
download.database('db_annovar_avsnp', database.dir = sprintf('\%s/databases/', tempdir()), 
show.all.versions = TRUE)
}
