% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rs2_rep_fc}
\alias{rs2_rep_fc}
\title{Gibbs update for dyadic variance with independent replicate relational data}
\usage{
rs2_rep_fc(E.T, rho)
}
\arguments{
\item{E.T}{Array of square residual relational matrix series. The third
dimension of the array is for different replicates. Each slice of the array
according to the third dimension is a square residual relational matrix}

\item{rho}{current value of rho}
}
\value{
a new value of s2
}
\description{
Gibbs update for dyadic variance with independent replicate relational data
}
\examples{
## The function is currently defined as
function(E.T,rho)
{
  N<-dim(E.T)[3]
  H<-mhalf( solve(matrix(c(1,rho,rho,1),2,2)) )
  EM<-NULL
  for (t in 1:N){
    E<-E.T[,,t]
    EM<-rbind(EM,cbind(E[upper.tri(E)],t(E)[upper.tri(E)] )\%*\%H)
  }
  1/rgamma(1, (length(EM)+1)/2 , (sum(EM^2)+1)/2 )
}
}
\author{
Peter Hoff, Yanjun He
}

