% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoord.R
\name{getCoord}
\alias{getCoord}
\title{Get coordinate from location}
\usage{
getCoord(
  address,
  key = NULL,
  city = NULL,
  sig = NULL,
  output = "tibble",
  callback = NULL,
  keep_bad_request = TRUE,
  mode = c("best", "all"),
  batch = FALSE,
  ...
)
}
\arguments{
\item{address}{Required.
Structured address information.
The value can be a character vector; each element will be queried in turn.}

\item{key}{Optional.
AutoNavi API key. You can also set this globally via
`options(amap_key = "your-key")`.}

\item{city}{Optional.
City hint that narrows down the search scope. When `batch = TRUE`,
only a single city value is supported.}

\item{sig}{Optional.
Digital signature supplied manually. Most users should instead enable
automatic signing via [with_amap_signature()] or [amap_config()].}

\item{output}{Optional.
Output data structure. Supported values are `"tibble"` (default),
`"JSON"`, and `"XML"`.}

\item{callback}{Optional.
JSONP callback. When supplied the raw body is returned as a character
vector.}

\item{keep_bad_request}{Optional.
When `TRUE` (default) API errors are converted into placeholder rows so
that vectorised or batched workflows continue. When `FALSE` errors are
raised as `amap_api_error` conditions.}

\item{mode}{Optional.
Controls how geocode candidates are returned. Use `"best"` (default) to
keep the highest ranked candidate for each query or `"all"` to return all
matches alongside ranking metadata.}

\item{batch}{Optional.
When `TRUE`, requests are chunked into groups of ten addresses using the
API's batch mode. Defaults to `FALSE` for backwards compatibility.}

\item{...}{Optional.
Included for forward compatibility only.}
}
\value{
When `output = "tibble"`, a `tibble` containing geocode results is
returned. The table preserves the input order and gains a
`rate_limit` attribute containing any rate limit headers returned by the API.
When `mode = "all"`, additional metadata columns (`query`, `query_index`,
and `match_rank`) are included. When `output` is `"JSON"` or `"XML"`,
the parsed body is returned without further processing.
}
\description{
Get coordinate from location
}
\examples{
\dontrun{
# Basic lookup (best match only)
getCoord("IFS Chengdu")

# Retrieve all candidates for a single query
getCoord("LOS ANGELES", mode = "all")

# Batch ten addresses at a time
getCoord(rep("Chengdu IFS", 12), batch = TRUE)

# Temporarily enable automatic request signing
with_amap_signature("your-secret", getCoord("IFS Chengdu"))
}
}
\seealso{
[extractCoord()], [with_amap_signature()], [amap_config()]
}
