% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxialShapeGraph.R
\docType{methods}
\name{unlinkCoords,AxialShapeGraph-method}
\alias{unlinkCoords,AxialShapeGraph-method}
\title{Unlink two Axial Lines (coordinates)}
\usage{
\S4method{unlinkCoords}{AxialShapeGraph}(map, fromX, fromY, toX, toY, copyMap = TRUE)
}
\arguments{
\item{map}{An Axial ShapeGraph}

\item{fromX}{X coordinate of the first unlink point}

\item{fromY}{Y coordinate of the first unlink point}

\item{toX}{X coordinate of the second unlink point}

\item{toY}{Y coordinate of the second unlink point}

\item{copyMap}{Optional. Copy the internal sala map}
}
\value{
A new Axial ShapeGraph with unlinked lines
}
\description{
Unlink two locations on an Axial ShapeGraph using the point coordinates
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
unlinkCoords(shapeGraph, 982.8, -1620.3, 1080.4, -1873.5)
}
