% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_disparity.R
\name{PlotDisparity}
\alias{PlotDisparity}
\title{Illustrate disparity plot.}
\usage{
PlotDisparity(
  object,
  which = NULL,
  lgcTtl = TRUE,
  lgcTtlX = TRUE,
  lgcTtlY = TRUE,
  lgcLgnd = TRUE,
  lgcLblZn = TRUE,
  szFntTtl = NULL,
  szFntTtlX = NULL,
  szFntTtlY = NULL,
  szFntAxsX = NULL,
  szFntAxsY = NULL,
  szFntLgnd = NULL,
  szPnt = NULL,
  szPntEC = NULL,
  szPntNEC = NULL,
  typPltCV = NULL,
  typPnt = NULL,
  typPntEC = NULL,
  typPntNEC = NULL,
  typLn0 = NULL,
  typLnEC = NULL,
  clrTtl = NULL,
  clrTtlX = NULL,
  clrTtlY = NULL,
  clrAxsX = NULL,
  clrAxsY = NULL,
  clrLgnd = NULL,
  clrVrtnL = NULL,
  clrVrtnM = NULL,
  clrVrtnH = NULL,
  clrLblZn = NULL,
  clrPnt = NULL,
  clrPntEC = NULL,
  clrPntNEC = NULL,
  clrLn0 = NULL,
  clrLnEC = NULL,
  sort = NULL
)
}
\arguments{
\item{object}{OBJECT of the disparity test output in \strong{disparity} class.}

\item{which}{CHARACTER for indicating type of disparity plot. Current
version consists of five plots, including disparity plot of
variability and outliers based on:
(1) coefficient of variance ("CV"),
(2) IQR-outlier ("IQR"),
(3) Z-outlier ("Z"),
(4) GESD-outlier ("GESD"),
(5) MAD-outlier ("MAD").}

\item{lgcTtl}{LOGIC value for indicating whether to show main title.}

\item{lgcTtlX}{LOGIC value for indicating whether to show title on axis X.}

\item{lgcTtlY}{LOGIC value for indicating whether to show title on axis Y.}

\item{lgcLgnd}{LOGIC value for indicating whether to show legend.}

\item{lgcLblZn}{LOGIC value for indicating whether to show labels of
variability zone.}

\item{szFntTtl}{NUMERIC value for indicating font size of main title.}

\item{szFntTtlX}{NUMERIC value for indicating font size of title on axis X.}

\item{szFntTtlY}{NUMERIC value for indicating font size of title on axis Y.}

\item{szFntAxsX}{NUMERIC value(s) for indicating font size of study label(s).}

\item{szFntAxsY}{NUMERIC value for indicating font size of scale on axis Y.}

\item{szFntLgnd}{NUMERIC value for indicating font size of legend.}

\item{szPnt}{NUMERIC value(s) for indicating size(s) of observed point(s).}

\item{szPntEC}{NUMERIC value for indicating size of observed point(s)
with excessive cases.}

\item{szPntNEC}{NUMERIC value for indicating size of observed point(s)
without excessive cases.}

\item{typPltCV}{CHARACTER for indicating sub-type of disparity plot for
showing variability. Current version provides two sub-types:
"half" and "full" plot.}

\item{typPnt}{NUMERIC value(s) for indicating type(s) of observed point(s).}

\item{typPntEC}{NUMERIC value for indicating type of observed point(s).
with excessive cases.}

\item{typPntNEC}{NUMERIC value for indicating type of observed point(s).
without excessive cases.}

\item{typLn0}{NUMERIC value for indicating type of horizontal line for no
excessive case.}

\item{typLnEC}{NUMERIC value for indicating type of vertical line(s) for
excessive case(s).}

\item{clrTtl}{CHARACTER of a color name for main title.}

\item{clrTtlX}{CHARACTER of a color name for title on axis X.}

\item{clrTtlY}{CHARACTER of a color name for title on axis Y.}

\item{clrAxsX}{CHARACTER of color name(s) for study label.}

\item{clrAxsY}{CHARACTER of a color name for scale on axis Y.}

\item{clrLgnd}{CHARACTER of a color name for legend.}

\item{clrVrtnL}{CHARACTER of a color name for low variability zone.}

\item{clrVrtnM}{CHARACTER of a color name for moderate variability zone.}

\item{clrVrtnH}{CHARACTER of a color name for high variability zone.}

\item{clrLblZn}{CHARACTER of color name(s) for variability zone(s).}

\item{clrPnt}{CHARACTER of color name(s) for every observed point.}

\item{clrPntEC}{CHARACTER of a color name for proportion of excessive cases.}

\item{clrPntNEC}{CHARACTER of a color name for observed point without
excessive case.}

\item{clrLn0}{CHARACTER of a color name for horizontal line of no excessive
case.}

\item{clrLnEC}{CHARACTER of color name for vertical line(s) of excessive
case(s).}

\item{sort}{CHARACTER of data sorting reference for disparity plot.
Currentversion consists of "time", "size", and "excessive"
for displaying observations on disparity plot of outlier(s).}
}
\value{
\strong{PlotDisparity()} returns a disparity plot.
}
\description{
\strong{PlotDisparity()} is a function for illustrating graphics of disparities in sample size analysis.
}
\references{
Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for
normality (complete samples). \strong{Biometrika}, \emph{52(3)}, 591-611.

Rosner, B. (1983). Percentage Points for a Generalized ESD Many-Outlier
Procedure. \strong{Technometrics}, \emph{25(2)}, 165-172.

Rousseeuw, P. J.  & Croux C. (1993). Alternatives to the Median Absolute
Deviation, \strong{Journal of the American Statistical Association}, \emph{88(424)},
1273-1283. http://dx.doi.org/10.1080/01621459.1993.10476408

Hendricks, W. A., & Robey, K. W. (1936). The sampling distribution of the
coefficient of variation. \strong{The Annals of Mathematical Statistics}, \emph{7(3)},
129-132.

Sokal, R. R., & Braumann, C. A. (1980). Significance tests for coefficients
of variation and variability profiles. \strong{Systematic Biology}, \emph{29(1)}, 50-66.
}
\seealso{
\code{\link{TestDisparity}}
}
\author{
Enoch Kang
}
