% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmBaselineCorrection.R
\name{afmBaselineCorrection}
\alias{afmBaselineCorrection}
\title{Performs a baseline correction to an AFM F-z curve}
\usage{
afmBaselineCorrection(afmdata, ZPointApp = NULL, ZPointRet = NULL,
fitpause = c("approach","retract","none"), vsTime = FALSE)
}
\arguments{
\item{afmdata}{An \code{afmdata} structure.}

\item{ZPointApp}{Point in the approach segment of the curve
that defines the approach baseline}

\item{ZPointRet}{Point in the retract segment of the curves that 
defines the retract baseline}

\item{fitpause}{Behaviour for the baseline correction at the pause segment: if "approach" (default), 
the pause segment is correted using the best line fit done on the approach segment, 
if "retract" the best line fit of the retract segment is used, if "none", no baseline correction 
is done on the pause segment.}

\item{vsTime}{Logical. If TRUE then the baseline correction is performed following the Force vs time approach 
described by S. Moreno-Flores (\cite{Moreno Flores (2016)}).}
}
\value{
\code{afmdata} An \code{afmdata} structure identical to the one in 
the input, but with an additional \code{ForceCorrected} column in the
 \code{data} dataframe of the \code{afmdata} structure.
}
\description{
This function performs the baseline correction to an AFM F-z curve within an
\code{afmdata} structure.

 It substracts a best fit line to the cuve: for the approach and contact 
 segments, it fits a line to the approach curve
points where for which |z|>ZPointApp and for the retract segment,
it fits a line to the retract curve where |z|> ZpointRet.

If no ZPointApp is given and the contact point has been already estimated 
(via \code{afmContactPoint()} function), then it is found as
\deqn{
ZPointApp = 0.7 ContactPoint + 0.3 max(Z)
}
}
\section{References}{
 
Moreno Flores (2016). 
Baseline correction of AFM force curves in the force-time representation.
Microscopy Research and Technique, 79, (11), pp. 1045-1049.
}
\examples{
AFMcurve <- afmReadJPK("force-save-JPK-2h.txt.gz", path = path.package("afmToolkit"))
ZPointApp <- 6.43e-6
ZPointRet <- 6.45e-6
AFMcurve <- afmBaselineCorrection(AFMcurve,ZPointApp = ZPointApp,ZPointRet = ZPointRet)
plot(AFMcurve)

# Without providing ZPointApp
AFMcurve <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path.package("afmToolkit"))
AFMcurve <- afmContactPoint(AFMcurve,width = 10,mul1 = 1,mul2 = 20, 
                             loessSmooth = FALSE)
AFMcurve <- afmBaselineCorrection(AFMcurve)
plot(AFMcurve)

}

