% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_map_taiwan}
\alias{plot_map_taiwan}
\title{plot_map_taiwan}
\usage{
plot_map_taiwan(
  long,
  lat,
  names,
  color = "darkgrey",
  textsize = 5,
  basesize = 16,
  shape_type = 22
)
}
\arguments{
\item{long}{Numeric vector of longitudes.}

\item{lat}{Numeric vector of latitudes.}

\item{names}{Character vector of site labels (same length as \code{long}).}

\item{color}{Fill colour for site markers. Default \code{"darkgrey"}.}

\item{textsize}{Size for annotation and point labels. Default 5.}

\item{basesize}{Base font size for the map theme. Default 16.}

\item{shape_type}{ggplot2 point shape number. Default 22 (filled square).}
}
\value{
A \code{ggplot} object (also printed to the active device).
}
\description{
Plot sampling sites on a map of Taiwan with a north arrow and
  scale bar.
}
\examples{
\dontrun{
plot_map_taiwan(
  long = c(120.2, 121.5),
  lat  = c(22.9, 24.1),
  names = c("Site A", "Site B")
)
}
}
