% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dtm.R
\name{compute_tmf}
\alias{compute_tmf}
\title{Derive the Time Imputation Flag}
\usage{
compute_tmf(dtc, dtm, ignore_seconds_flag = TRUE)
}
\arguments{
\item{dtc}{The date character vector (\code{--DTC}).

A character date is expected in a format like \code{yyyy-mm-ddThh:mm:ss} (partial or complete).

\describe{
\item{Default value}{none}
}}

\item{dtm}{The Date vector to compare (\verb{*DTM}).

A datetime object is expected.

\describe{
\item{Default value}{none}
}}

\item{ignore_seconds_flag}{ADaM IG states that given SDTM (\code{--DTC}) variable,
if only hours and minutes are ever collected, and seconds are imputed in
(\verb{*DTM}) as 00, then it is not necessary to set (\verb{*TMF}) to \code{"S"}.

By default it is assumed that no seconds are collected and \verb{*TMF} shouldn't be set to \code{"S"}.
A user can set this to \code{FALSE} if seconds are collected.

The default value of \code{ignore_seconds_flag} is set to \code{TRUE} in
admiral 1.4.0 and later.

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{TRUE}}
}}
}
\value{
The time imputation flag (\verb{*TMF}) (character value of \code{"H"}, \code{"M"} , \code{"S"} or \code{NA})
}
\description{
Derive the time imputation flag (\verb{*TMF}) comparing a date character vector
(\code{--DTC}) with a Datetime vector (\verb{*DTM}).
}
\details{
Usually this computation function can not be used with \verb{\%>\%}.
}
\examples{
library(lubridate)

compute_tmf(dtc = "2019-07-18T15:25", dtm = ymd_hm("2019-07-18T15:25"))
compute_tmf(dtc = "2019-07-18T15", dtm = ymd_hm("2019-07-18T15:25"))
compute_tmf(dtc = "2019-07-18", dtm = ymd("2019-07-18"))
compute_tmf(dtc = "2022-05--T00:00", dtm = ymd_hm("2022-05-15T23:59"))
compute_tmf(dtc = "2022-05--T23:00", dtm = ymd_hm("2022-05-15T23:59"))
compute_tmf(
  dtc = "2022-05--T23:59:00",
  dtm = ymd_hms("2022-05-15T23:59:59"),
  ignore_seconds_flag = FALSE
)

}
\seealso{
Date/Time Computation Functions that returns a vector:
\code{\link{compute_age_years}()},
\code{\link{compute_dtf}()},
\code{\link{compute_duration}()},
\code{\link{convert_date_to_dtm}()},
\code{\link{convert_dtc_to_dt}()},
\code{\link{convert_dtc_to_dtm}()},
\code{\link{convert_xxtpt_to_hours}()},
\code{\link{impute_dtc_dt}()},
\code{\link{impute_dtc_dtm}()}
}
\concept{com_date_time}
\keyword{com_date_time}
