% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkArguments}
\alias{checkArguments}
\title{Check argument quality}
\usage{
checkArguments(
  dp,
  tz,
  minimum.detections,
  max.interval,
  speed.method = c("last to first", "last to last"),
  speed.warning,
  speed.error,
  start.time,
  stop.time,
  report,
  auto.open,
  save.detections,
  jump.warning,
  jump.error,
  inactive.warning,
  inactive.error,
  exclude.tags,
  override,
  print.releases,
  plot.detections.by = c("stations", "arrays"),
  if.last.skip.section = NULL,
  replicates = NULL,
  section.minimum = NULL,
  section.order = NULL,
  timestep = c("days", "hours")
)
}
\arguments{
\item{dp}{A preloaded datapack (or NULL if no data was preloaded).}

\item{tz}{The time zone of the study area. Must match one of the values
present in \code{\link[base]{timezones}}.}

\item{minimum.detections}{For tags with only one movement event, defines the
minimum number of times a tag must have been recorded during the study
period for it to be considered true detections and not random noise.
Defaults to 2.}

\item{max.interval}{The number of minutes that must pass between detections
for a new event to be created. Defaults to 60.}

\item{speed.method}{Can take two forms: 'last to first' or 'last to last'.
If 'last to first' (default), the last detection on the previous array is matched
to the first detection on the target array to perform the calculations.
If 'last to last', the last detection on ´the previous array is matched to the
last detection on the target array to perform the calculations.}

\item{speed.warning}{If a tag moves at a speed equal or greater than
\code{speed.warning} (in metres per second), a warning is issued. If left
NULL (default), no warnings are issued.}

\item{speed.error}{If a tag moves at a speed equal or greater than
\code{speed.error} (in metres per second), user intervention is suggested.
If left NULL (default), user intervention is never suggested.}

\item{start.time}{Detection data prior to the timestamp set in
\code{start.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{stop.time}{Detection data posterior to the timestamp set in
\code{stop.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{report}{Logical. Should an HTML report be created at the end of the
analysis? NOTE: Setting report to TRUE will generate an HTML file in the current
directory. Additionally, if auto.open = TRUE (default), the web browser will
automatically be launched to open the report once the function terminates.}

\item{auto.open}{Logical: Should the report be automatically opened once the
analysis is over? Defaults to TRUE. NOTE: If report = TRUE and auto.open = TRUE,
the web browser will automatically be launched to open the report once the
function terminates.}

\item{save.detections}{Logical: Should the processed detections be saved for
future runs?}

\item{jump.warning}{If a tag crosses a number of arrays equal or greater
than \code{jump.error} without being detected, a warning is issued. If left
NULL (default), no warnings are issued.}

\item{jump.error}{If a tag crosses a number of arrays equal or greater than
\code{jump.error} without being detected, user intervention is suggested.
If left NULL (default), user intervention is never suggested.}

\item{inactive.warning}{If a tag spends a number of days equal or greater
than \code{inactive.error} in a given array at the tail of the respective
detections, a warning is issued. If left NULL (default), no warnings are
issued.}

\item{inactive.error}{If a tag spends a number of days equal or greater than
\code{inactive.error} in a given array at the tail of the respective
detections, user intervention is suggested. If left NULL (default), user
intervention is never suggested.}

\item{exclude.tags}{A vector of tags that should be excluded from the
detection data before any analyses are performed. Intended to be used if
stray tags from a different code space but with the same signal as a target
tag are detected in the study area.}

\item{override}{A vector of signals for which the user intends to manually
define which movement events are valid and invalid.}

\item{print.releases}{Logical: Should the release sites be printed in the
study area diagrams?}

\item{plot.detections.by}{The type of y axis desired for the individual
detection plots. One of "stations" (default) or "arrays".}

\item{if.last.skip.section}{Logical: Should a tag detected at the last array
of a given section be considered to have disappeared in the next section?}

\item{replicates}{A list containing, for each array to which intra-array
efficiency is to be calculated: The standard names of the stations to be
used as a replicate. See the vignettes for more details.}

\item{section.minimum}{If a tag has less than \code{section.minimum}
consecutive detections in a section, a warning is issued. Defaults to 2.}

\item{section.order}{A vector containing the order by which sections should
be aligned in the results.}

\item{timestep}{The resolution desired for the residency calculations.
One of "days" (default) or "hours".}
}
\value{
updated parameters
}
\description{
Check argument quality
}
\keyword{internal}
