% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnres_sim.R
\name{lnres_sim}
\alias{lnres_sim}
\title{Simulate a water quality time series}
\usage{
lnres_sim(dat_in, lnQ_coef = NULL)
}
\arguments{
\item{dat_in}{input \code{\link[base]{data.frame}} that must include estimated error and simulated discharge time series, see \code{\link{lnres_err}} and \code{\link{lnQ_sim}} respectively}

\item{lnQ_coef}{numeric vector of coefficients of the same length of the time series in \code{dat_in} that is multiplied by the discharge vector, see details}
}
\value{
The original data frame with additional columns for the seasonal water quality model (\code{lnres_seas}), a flow-independent water quality time series (\code{lnres_noQ}), and a flow-dependent time series (\code{lnres_Q}).
}
\description{
Simulate a water quality time series with an estimated error structure and simulated discharge effect
}
\details{
This function creates a simulated water quality time series and requires error estimates for an observed water quality dataset and a simulated discharge time series.  The water quality time series is created as the additive combination of a seasonal, stationary time component (as in \code{\link{lnQ_sim}} for discharge), a random error component from \code{\link{lnres_err}}, and a simulated discharge time series from \code{\link{lnQ_sim}}.  The discharge time series is considered an explicit component of the water quality time series and is first centered at zero prior to adding.  The optional vector of coefficients passed to \code{lnQ_coef} can mediate the influence of discharge on the water quality time series.  For example, a vector of all zeroes implies no effect, whereas a vector of all ones implies a constant effect (default).
}
\examples{
\dontrun{
## example data
data(daydat)

## get simulated discharge
sims <- lnQ_sim(daydat)

## get error structure of wq time series
sims <- lnres_err(sims)

## get simulated wq time series using results from previous
lnres_sim(sims)
}
}
\seealso{
\code{\link{daydat}} for the format of an input dataset, \code{\link{lnQ_sim}} for simulating discharge, and \code{\link{lnres_err}} for estimating the error distribution of the water quality time series, \code{\link{all_sims}} for completing all steps at once.
}
