% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsrch_grid.R
\name{winsrch_grid}
\alias{winsrch_grid}
\alias{winsrch_grid.default}
\title{Evaluate half-window width combinations}
\usage{
winsrch_grid(dat_in, ...)

\method{winsrch_grid}{default}(dat_in, grid_in = NULL, ...)
}
\arguments{
\item{dat_in}{input data object to use with weighted regression}

\item{...}{arguments passed to or from other methods}

\item{grid_in}{optional input matrix of half-window widths created with \code{\link{createsrch}}, a default search grid is used if no input}
}
\value{
A data frame of the search grid with associated errors for each cross-validation result.  Errors for each grid row are averages of all errors for each fold used in cross-validation.
}
\description{
Evaluate a grid of half-window width combinations to use for weighted regression
}
\details{
Processing time can be reduced by setting up a parallel backend, as in the examples.  Note that this is not effective for small k-values (e.g., < 4) because each fold is sent to a processor, whereas the window width combinations in \code{grid_in} are evaluated in sequence.  

This function should only be used to view the error surface assocatied with finite combinations of window-width combinations.  A faster function to identify the optimal window widths is provided by \code{\link{winsrch_optim}}.
}
\examples{
\dontrun{
##
# setup parallel backend
library(doParallel)
ncores <- detectCores() - 2 
registerDoParallel(cores = ncores)

# run search function using default search grid - takes a while
res <- winsrch_grid(tidobjmean)

# view the error surface 
library(ggplot2)
ggplot(res, aes(x = factor(mos), y = factor(yrs), fill = err)) +
   geom_tile() + 
   facet_wrap(~ flo) + 
   scale_x_discrete(expand = c(0, 0)) +
   scale_y_discrete(expand = c(0,0)) +
   scale_fill_gradientn(colours = gradcols()) 

# optimal combo
res[which.min(res$err), ]

##
# create a custom search grid, e.g. years only
grid_in <- createsrch(mos = 1, yrs = seq(1, 10), flo = 1)

res <- winsrch_grid(tidobjmean, grid_in)

}
}
\seealso{
\code{\link{createsrch}}, \code{\link{wrtdscv}}, \code{\link{winsrch_optim}}
}

