% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrtds.R
\name{wrtds}
\alias{wrtds}
\alias{wrtds.tidal}
\alias{wrtds.tidalmean}
\title{Get WRTDS prediction grid}
\usage{
wrtds(dat_in, ...)

\method{wrtds}{tidal}(dat_in, flo_div = 10, tau = 0.5, trace = TRUE,
  fill_empty = FALSE, ...)

\method{wrtds}{tidalmean}(dat_in, flo_div = 10, fill_empty = FALSE,
  trace = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to or from other methods}

\item{flo_div}{numeric indicating number of divisions across the range of salinity/flow to create the interpolation grid}

\item{tau}{numeric vector indicating conitional quantiles to fit in the weighted regression, can be many}

\item{trace}{logical indicating if progress is shown in the console}

\item{fill_empty}{logical to fill missing values in interpolation grid using bilinear interpolation by season, see details}
}
\value{
Appends interpolation grid attributes to the input object.  For a tidal object, this could include multiple grids for each quantile.  For tidalmean objects, only one grid is appended to the `fits' attribute, in addition to a back-transformed grid as the `bt_fits' attribute and a grid of the scale parameter of each prediction as the `scls' attribute.  Grid rows correspond to the dates in the input data.

The \code{fill_empty} arguments uses bilinear interpolation of time by flow to fill missing data in the interpolation grids.  The grids are subset by month before interpolating to retain the seasonal variation captured by the models.  In gneral, this argument should not be used if more than ten percent of the interpolation grids are missing data.  It may be helpful to improve visual appearance of some of the plotting results.
}
\description{
Get WRTDS prediction grid for observations of the response variable in a tidal or tidalmean object
}
\examples{
\dontrun{
## load data
data(chldat)

## as tidal object
dat_in <- tidal(chldat)
res <- wrtds(dat_in)

## as tidalmean object
dat_in <- tidalmean(chldat)
res <- wrtds(dat_in)

## multiple quantiles
res <- wrtds(dat_in, tau = c(0.1, 0.5, 0.9))
}
}

