% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0S4.R, R/simon_oc.R
\docType{class}
\name{simon_oc}
\alias{simon_oc}
\alias{simon_oc-class}
\alias{simon_oc.ph2simon}
\alias{simon_oc.ph2simon4}
\title{Operating Characteristics of Simon's Two-Stage Design}
\usage{
simon_oc(prob, R, object, ...)

\method{simon_oc}{ph2simon}(prob, R = 10000L, object, ...)

\method{simon_oc}{ph2simon4}(
  prob,
  R = 10000L,
  object,
  ...,
  r1 = object@r1,
  n1 = object@n1,
  r = object@r,
  n = object@n
)
}
\arguments{
\item{prob}{\emph{named} \link[base]{double} \link[base]{vector},
true response rate(s) \eqn{p} of (multiple) drug(s).
The \code{names(prob)} should be the name(s) of the drug(s).}

\item{R}{\link[base]{integer} scalar, number of simulations.  Default \code{1e4L}.}

\item{object}{\link[clinfun]{ph2simon} or \linkS4class{ph2simon4} object}

\item{...}{parameters of function \code{\link[=ph2simon4]{ph2simon4()}}, most importantly \code{type}}

\item{r1, n1, r, n}{(optional) \link[base]{integer} scalars, see \linkS4class{ph2simon4}.}
}
\value{
Function \code{\link[=simon_oc]{simon_oc()}} returns \linkS4class{simon_oc} object.
}
\description{
Operating characteristics of \strong{one} Simon's two-stage design.
}
\section{Slots}{

\describe{
\item{\code{maxResp}}{\link[base]{integer} \link[base]{vector} of same length as \eqn{p},
the frequencies of each regime having maximum response.
The summation of \code{maxResp} is the number of simulation copies.}

\item{\code{simon_maxResp}}{\link[base]{integer} \link[base]{vector} of same length as \eqn{p},
the frequencies of each regime having maximum response and success in Simon's two-stage trial.}
}}

\keyword{internal}
