% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_R_fit_comparison}
\alias{plot_R_fit_comparison}
\title{Compare Reproduction Number Estimates from Multiple EpiEstim Outputs}
\usage{
plot_R_fit_comparison(...)
}
\arguments{
\item{...}{Named EpiEstim output objects produced by \code{\link[=generate_forecast]{generate_forecast()}}.
Each object should contain a data frame \code{estimate_R$R} with columns such as:
\itemize{
\item \code{t_start}, \code{t_end}: Time window indices
\item \code{Median(R)}: Median estimated reproduction number
\item \code{Quantile.0.025(R)} / \code{Quantile.0.975(R)}: 95\% credible interval bounds
\item \code{Quantile.0.25(R)} / \code{Quantile.0.75(R)}: 50\% credible interval bounds
}}
}
\value{
A \strong{ggplot2} object showing median \eqn{R} estimates with 50\% and 95\% credible intervals,
colored by input source (i.e., name).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is deprecated and may be removed in a future release.

This function creates a ggplot comparing estimated reproduction numbers (\eqn{R})
over time from multiple EpiEstim outputs. Each input should be a named object
produced by EpiEstim containing an \code{estimate_R$R} data frame.
}
\seealso{
\code{\link[=generate_forecast]{generate_forecast()}}, \code{\link[EpiEstim:estimate_R]{EpiEstim::estimate_R()}}
}
\keyword{internal}
