% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trvsvisit.R
\name{trvssubinq}
\alias{trvssubinq}
\title{Using sub vector binary tree to visit the traversal table}
\usage{
trvssubinq(trvs, inq)
}
\arguments{
\item{trvs}{The traversal table to be visited, which should be generated from the vector binary tree by the function trvs().}

\item{inq}{A sub tree generated from the original vector binary tree, to determine the subset of elements to be visited.}
}
\value{
Return a list containing the numeric index, the character pattern and the corresponding coordinate for each item.
}
\description{
Visit the traversal table generated from a vector binary tree through the sub vector binary tree determined by the argument \code{inq}, and
return an inquiry list containing the numeric index, the character pattern and the corresponding coordinate for each item.
}
\examples{
#Make original vector binary tree and its traversal table:
vbt <- dl2vbt(chrvec2dl(colnames(datatest)))
trav <- trvs(vbt)

#Visit all elements defined by sub vector binary tree:
#example 1: visit all "Stress-*-*-*" patterns;
#make sub vector binary tree through vbtsub() then execute inquiry:
subvbt <- vbtsub(vbt, c(2,-1,-1,-1))
trvssubinq(trav, subvbt)

#example 2: visit all "Strain-("950", "1050")-("0.001", "0.1")-*" patterns;
#make sub vector binary tree through advbtsub() then execute inquiry:
subvbt <- advbtsub(vbt, list(1, c(2,4), c(1,3), 1))
trvssubinq(trav, subvbt)
}
\seealso{
\code{\link[VBTree:vbtsub]{vbtsub}}, \code{\link[VBTree:advbtsub]{advbtsub}}.
}
\keyword{Trav.Inq}
\keyword{Trav.Table}
\keyword{Vector.Binary.Tree}
