% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.test_sh.R
\name{normality.test_sh}
\alias{normality.test_sh}
\title{Normality, multivariate skewness and kurtosis test}
\usage{
normality.test_sh(x, multivariate.only = TRUE)
}
\arguments{
\item{x}{An object of class "varshrinkest" obtained by VARshrink().}

\item{multivariate.only}{If TRUE, only the multivariate statistics
is computed.}
}
\description{
This function computes univariate and multivariate Jarque-Bera tests and
multivariate skewness and kurtosis tests for the residuals of a VAR(p)
or of a VECM in levels.
This is a modification of vars::normality.test() for
the class "varshrinkest".
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
normality.test_sh(estim)
}
\seealso{
\code{\link[vars]{normality.test}}
}
