% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arch.test_sh.R
\name{arch.test_sh}
\alias{arch.test_sh}
\title{ARCH-LM test}
\usage{
arch.test_sh(x, lags.single = 16, lags.multi = 5,
  multivariate.only = TRUE)
}
\arguments{
\item{x}{An object of class "varshrinkest" obtained by VARshrink()}

\item{lags.single}{An integer of the lag order used for
univariate ARCH statistics.}

\item{lags.multi}{An integer of the lag order used for
multivariate ARCH statistic.}

\item{multivariate.only}{If TRUE, only the multivariate statistic
is computed.}
}
\description{
Performs univariate and multivariate ARCH-LM tests for a VAR.
This is a modification of vars::arch.test() for the class "varshrinkest".
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
arch.test_sh(estim)
}
\seealso{
\code{\link[vars]{arch.test}}
}
