% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{plot.VARDetect.result}
\alias{plot.VARDetect.result}
\title{Plotting the output from VARDetect.result class}
\usage{
\method{plot}{VARDetect.result}(
  x,
  display = c("cp", "param", "granger", "density"),
  threshold = 0.1,
  layout = c("circle", "star", "nicely"),
  ...
)
}
\arguments{
\item{x}{a \code{VARDetect.result} object}

\item{display}{a character string, indicates the object the user wants to plot; possible values are
\describe{
    \item{\code{"cp"}}{input time series together with the estimated change points}
    \item{\code{"param"}}{estimated model parameters}
    \item{\code{"granger"}}{present the model parameters through Granger causal networks}
    \item{\code{"density"}}{plot the sparsity levels across all segments}
}}

\item{threshold}{a positive numeric value, indicates the threshold to present the entries in the sparse matrices}

\item{layout}{a character string, indicating the layout of the Granger network}

\item{...}{not in use}
}
\value{
A plot for change points or a series of plots for Granger causal networks for estimated model parameters
}
\description{
Plotting method for S3 object of class \code{VARDetect.result}
}
\examples{
nob <- 1000
p <- 15
brk <- c(floor(nob / 3), floor(2 * nob / 3), nob + 1)
m <- length(brk)
q.t <- 1
try <- simu_var('sparse',nob=nob,k=p,lags=q.t,brk=brk,sp_pattern="off-diagonal",seed = 1)
data <- try$series
data <- as.matrix(data)
fit <- tbss(data, method = "sparse", q = q.t)
plot(fit, display = "cp")
plot(fit, display = "param")
plot(fit, display = "granger", threshold = 0.2, layout = "nicely")
plot(fit, display = "density", threshold = 0.2)
}
