% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{simu_var}
\alias{simu_var}
\title{Generate VAR(p) model data with break points}
\usage{
simu_var(
  method = c("sparse", "group sparse", "fLS", "LS"),
  nob = 300,
  k = 20,
  lags = 1,
  lags_vector = NULL,
  brk,
  sigma = NULL,
  skip = 50,
  spectral_radius = 0.98,
  seed = NULL,
  sp_density = NULL,
  group_mats = NULL,
  group_index = NULL,
  group_type = c("columnwise", "rowwise"),
  sparse_mats = NULL,
  sp_pattern = c("off-diagonal", "diagonal", "random"),
  rank = NULL,
  info_ratio = NULL,
  signals = NULL,
  singular_vals = NULL
)
}
\arguments{
\item{method}{the structure of time series: "sparse","group sparse", "fLS", "LS"}

\item{nob}{sample size}

\item{k}{dimension of transition matrix}

\item{lags}{lags of VAR time series. Default is 1.}

\item{lags_vector}{a vector of lags of VAR time series for each segment}

\item{brk}{a vector of break points with (nob+1) as the last element}

\item{sigma}{the variance matrix for error term}

\item{skip}{an argument to control the leading data points to obtain a stationary time series}

\item{spectral_radius}{to ensure the time series is piecewise stationary.}

\item{seed}{an argument to control the random seed. Default seed is 1.}

\item{sp_density}{if we choose random pattern, we should provide the sparsity density for each segment}

\item{group_mats}{transition matrix for group sparse case}

\item{group_index}{group index for group lasso.}

\item{group_type}{type for group lasso: "columnwise", "rowwise". Default is "columnwise".}

\item{sparse_mats}{transition matrix for sparse case}

\item{sp_pattern}{a choice of the pattern of sparse component: diagonal, 1-off diagonal, random, custom}

\item{rank}{if we choose method is low rank plus sparse, we need to provide the ranks for each segment}

\item{info_ratio}{the information ratio leverages the signal strength from low rank and sparse components}

\item{signals}{manually setting signal for each segment (including sign)}

\item{singular_vals}{singular values for the low rank components}
}
\value{
A list object, which contains the followings
\describe{
  \item{series}{matrix of timeseries data}
  \item{noises}{matrix of noise term data}
  \item{sparse_mats}{list of sparse matrix in the transition matrix}
  \item{lowrank_mats}{list of low-rank matrix in the transition matrix}
}
}
\description{
This function is used for generate simulated time series
}
\examples{
nob <- (10^3*4); #number of time points
p <- 15; # number of time series components
brk <- c(floor(nob/3),floor(2*nob/3),nob+1); # true break points with nob+1 as the last element
m0 <- length(brk) -1; # number of break points
q.t <- 2; # the true AR order
m <- m0+1 #number of segments
sp_density <- rep(0.05, m*q.t) #sparsity level (5\%)
try<-simu_var("sparse",nob=nob,k=p,lags=q.t,brk =brk,sp_pattern="random",sp_density=sp_density)
print(plot_matrix(do.call("cbind",try$model_param), m*q.t ))

}
