\name{Sampler}
\alias{Sampler}
\title{Generate a Markov chain sampler}
\description{Generates a Markov chain sampling function given a list of parameters}
\usage{
Sampler(...)
}
\arguments{
  \item{\dots}{ A list of parameters including Gibbs and/or Metropolis updating routines, Raw functions and other objects}
}
\details{
\code{Sampler} generates an R function to produce simulations
wrapped in an  \code{mcts} object that can be coerced into
random variable objects, for example.

A \code{Sampler} function call features a named argument list that represents
the named parameters in a Gibbs or Metropolis sampler.
The names are specified by the user (e.g. "theta", "alpha")
and the values are either constants (vectors of data frames),
special Umacs objects implementing a sampling scheme
(\code{Gibbs}, \code{Metropolis}, etc.).
Additionally, the argument list can contain assignments to special internal variables,
or unnamed arguments such as raw code to be embedded in the sampling loop.

Special Umacs variables that are identified by the prepending dot (e.g. \code{.logpost})
and are not thus actual parameters in the model.

No user-defined parameter can start with a dot.

Unnamed arguments are either `raw' functions that are embedded `as is'
inside the sampling loop, or special Umacs objects such as \code{\link{Trace}} objects,
which provide a trace plots of a specified variable.
The code that the user provides in the form of direct sampling functions
(via \code{Gibbs}) or log-posterior functions
(via the various Metropolis updating schemes) can have references to
`global' variables that are available in the workspace,
but also to `local' variables that are specified within the \code{Sampler} function call.

Ideally, the function should \emph{only} have references to
local variables so that the resulting sampler function is
a stand-alone function that encapsulates
a complete sampling environment independent of the working environment.

`Raw code' that is specified as an unnamed function in the argument list
is embedded as a function, so any assignments done using the \code{<-} operator are local.
To change directly the value of a \emph{parameter}, use the \code{<<-} operator.

The allowed values for the \emph{parameters} that (are named by the user and)
can be passed as arguments are:

A constant numeric value (vector or array).
The variable is made available to the functions embedded in the sampler
(but not in Global Environment!), or,
a \code{SamplingScheme} object that is built using one of
the following possible functions:
\code{\link{Gibbs}}, \code{\link{Metropolis}}, \code{\link{SMetropolis}}, \code{\link{PMetropolis}},
\code{\link{PSMetropolis}}.

These objects provide the updating and initialization functions for
a Gibbs updating step, or the log-posterior function
and an initialization function for a Metropolis updating step.

(Technically speaking, a `Gibbs' updating step is just a special case of
a `Metropolis' updating step in the sense that all samples generated
using the function of a `Gibbs' updating step are accepted unconditionally.)

The allowed values for the \emph{unnamed} objects that can be passed as arguments are a
\code{\link{Trace}} object, or a plain function (`raw code').
The plain function is converted internally first to a \code{\link{RawCode}} object,
so giving a plain function is made possible just for convenience.
See \code{\link{RawCode}} for details.

}
\value{
An R function that can be run to produce the simulations.

See the help page for \code{\link{Umacs}} to learn about the usage of the sampling function.

The function generated by \code{Sampler} returns an \code{\link{mcts}} object that can be
converted into random variable objects.
}
\references{Kerman, Jouni. Umacs: A Universal Markov Chain Sampler. Technical report, Columbia University, New York.}
\author{Jouni Kerman <jouni@kerman.com>}
\note{}
\seealso{
\code{\link{Umacs-package}} for an overview of the Umacs package.

\code{\link{Sampler}} for how to create a sampler function; see the vignette for details.

Package `rv'.

}
\examples{}
\keyword{iteration}
