% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPhaseDesign.R
\name{TwoPhaseDesign}
\alias{TwoPhaseDesign}
\title{Two-Phase Experimental Design Construction and Analysis}
\usage{
TwoPhaseDesign(v, rho, plot = TRUE)
}
\arguments{
\item{v}{Integer (>=3). Number of treatments in Phase II.}

\item{rho}{Numeric (-1 < rho < 1). Correlation coefficient.}

\item{plot}{Logical. If TRUE (default), generates a CEF plot using ggplot2.}
}
\value{
A list containing the Phase I and Phase II layouts, combined layout,
        information matrices for treatment and interaction effects, and a
        table and plot of Canonical Efficiency Factors.
}
\description{
Constructs and evaluates a two-phase experimental design using cyclic methods.
Calculates information matrices and Canonical Efficiency Factor (CEF) under
correlated error structures.
}
\examples{
result <- TwoPhaseDesign(v = 3, rho = 0.1, plot = FALSE)
print(result$cef_table)

}
\references{
McIntyre, G. A. (1955). \emph{Design and analysis of two-phase experiments}. Biometrics, 11(3), 324-334.
<doi:10.2307/3001770>
}
